/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.smtp;

import com.elastisys.scale.commons.net.smtp.SmtpMessage;
import com.elastisys.scale.commons.net.smtp.SmtpServerSettings;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpSender
implements Callable<Boolean> {
    static final Logger LOG = LoggerFactory.getLogger(SmtpSender.class);
    private final SmtpMessage message;
    private final SmtpServerSettings serverSettings;

    public SmtpSender(SmtpMessage message, SmtpServerSettings serverSettings) {
        this.message = message;
        this.serverSettings = serverSettings;
    }

    @Override
    public Boolean call() throws Exception {
        this.sendMessage(this.message, this.serverSettings);
        return true;
    }

    private void sendMessage(SmtpMessage smtpMessage, SmtpServerSettings settings) throws EmailException {
        Preconditions.checkNotNull(this.message, "alert message cannot be null");
        if (LOG.isTraceEnabled()) {
            LOG.trace("sending email to {} with server settings {}", (Object)smtpMessage.getTo(), (Object)settings);
        }
        SimpleEmail email = new SimpleEmail();
        email.setHostName(settings.getSmtpHost());
        email.setSmtpPort(settings.getSmtpPort());
        email.setFrom(smtpMessage.getFrom().toString());
        email.setSubject(smtpMessage.getSubject());
        ((Email)email).setMsg(smtpMessage.getContent());
        email.setTo(smtpMessage.getTo());
        email.setSentDate(smtpMessage.getDateSent().toDate());
        if (settings.getAuthentication() != null) {
            email.setAuthentication(settings.getAuthentication().getUserName(), settings.getAuthentication().getPassword());
        }
        if (settings.isUseSsl()) {
            email.setSSLOnConnect(true);
        } else {
            email.setStartTLSEnabled(true);
        }
        email.setSocketConnectionTimeout(settings.getConnectionTimeout());
        email.setSocketTimeout(settings.getSocketTimeout());
        email.send();
        if (LOG.isTraceEnabled()) {
            LOG.trace("email sent to " + smtpMessage.getTo());
        }
    }
}

