/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.smtp;

import com.elastisys.scale.commons.net.smtp.ClientAuthentication;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class SmtpServerSettings {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private final String smtpHost;
    private final Integer smtpPort;
    private final ClientAuthentication authentication;
    private final Boolean useSsl;
    private final Integer connectionTimeout;
    private final Integer socketTimeout;

    public SmtpServerSettings(String smtpHost, Integer smtpPort, ClientAuthentication authentication) {
        this(smtpHost, smtpPort, authentication, false, 30000, 30000);
    }

    public SmtpServerSettings(String smtpHost, Integer smtpPort, ClientAuthentication authentication, Boolean useSsl) {
        this(smtpHost, smtpPort, authentication, useSsl, 30000, 30000);
    }

    public SmtpServerSettings(String smtpHost, Integer smtpPort, ClientAuthentication authentication, Boolean useSsl, int connectionTimeout, int socketTimeout) {
        this.smtpHost = smtpHost;
        this.smtpPort = smtpPort;
        this.authentication = authentication;
        this.useSsl = useSsl;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.validate();
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    public ClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public int hashCode() {
        return Objects.hashCode(this.smtpHost, this.smtpPort, this.authentication, this.useSsl, this.connectionTimeout, this.socketTimeout);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmtpServerSettings) {
            SmtpServerSettings that = (SmtpServerSettings)obj;
            return Objects.equal(this.smtpHost, that.smtpHost) && Objects.equal(this.smtpPort, that.smtpPort) && Objects.equal(this.authentication, that.authentication) && Objects.equal(this.useSsl, that.useSsl) && Objects.equal(this.connectionTimeout, that.connectionTimeout) && Objects.equal(this.socketTimeout, that.socketTimeout);
        }
        return super.equals(obj);
    }

    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.smtpHost != null, "missing smtpHost");
        Preconditions.checkArgument(this.smtpPort != null, "missing smtpPort");
        Preconditions.checkArgument(this.smtpPort > 0, "missing smtpPort");
        Preconditions.checkArgument(this.useSsl != null, "missing useSsl");
        Preconditions.checkArgument(this.connectionTimeout >= 0, "negative connectionTimeout");
        Preconditions.checkArgument(this.socketTimeout >= 0, "negative socketTimeout");
        if (this.authentication != null) {
            this.authentication.validate();
        }
    }

    public String toString() {
        return Objects.toStringHelper(this).add("smtpHost", this.smtpHost).add("smtpPort", this.smtpPort).add("useSsl", this.useSsl).add("authentication", this.authentication).add("connectionTimeout", this.connectionTimeout).add("socketTimeout", this.socketTimeout).toString();
    }
}

