/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.smtp.alerter;

import com.elastisys.scale.commons.net.smtp.alerter.AlertSeverity;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.joda.time.DateTime;

public class Alert {
    private final String topic;
    private final AlertSeverity severity;
    private final DateTime timestamp;
    private final String message;
    private final SortedMap<String, String> tags;

    public Alert(String topic, AlertSeverity severity, DateTime timestamp, String message) {
        this(topic, severity, timestamp, message, new HashMap<String, String>(0));
    }

    public Alert(String topic, AlertSeverity severity, DateTime timestamp, String message, Map<String, String> tags) {
        Preconditions.checkNotNull(topic, "topic cannot be null");
        Preconditions.checkNotNull(severity, "severity cannot be null");
        Preconditions.checkNotNull(timestamp, "timestamp cannot be null");
        Preconditions.checkNotNull(message, "message cannot be null");
        Preconditions.checkNotNull(tags, "tags cannot be null");
        this.topic = topic;
        this.severity = severity;
        this.timestamp = timestamp;
        this.message = message;
        this.tags = Maps.newTreeMap();
        this.tags.putAll(tags);
    }

    public String getTopic() {
        return this.topic;
    }

    public AlertSeverity getSeverity() {
        return this.severity;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Alert withTag(String tag, String value) {
        HashMap<String, String> extendedTags = Maps.newHashMap(this.getTags());
        extendedTags.put(tag, value);
        return new Alert(this.topic, this.severity, this.timestamp, this.message, extendedTags);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("topic", this.topic).add("severity", (Object)this.severity).add("timestamp", this.timestamp).add("message", this.message).add("tags", this.tags).toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.topic, this.severity, this.timestamp, this.message, this.tags});
    }

    public boolean equals(Object other) {
        if (other instanceof Alert) {
            Alert that = (Alert)other;
            return Objects.equal(this.topic, that.topic) && Objects.equal((Object)this.severity, (Object)that.severity) && Objects.equal(this.timestamp, that.timestamp) && Objects.equal(this.message, that.message) && Objects.equal(this.tags, that.tags);
        }
        return false;
    }
}

