/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.smtp.alerter;

import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.net.smtp.SmtpMessage;
import com.elastisys.scale.commons.net.smtp.SmtpSender;
import com.elastisys.scale.commons.net.smtp.SmtpServerSettings;
import com.elastisys.scale.commons.net.smtp.alerter.Alert;
import com.elastisys.scale.commons.net.smtp.alerter.SendSettings;
import com.elastisys.scale.commons.util.time.UtcTime;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAlerter {
    static final Logger LOG = LoggerFactory.getLogger(EmailAlerter.class);
    private final SmtpServerSettings smtpServerSettings;
    private final SendSettings sendSettings;
    private final Map<String, String> standardTags;

    public EmailAlerter(SmtpServerSettings smtpServerSettings, SendSettings sendSettings) {
        this(smtpServerSettings, sendSettings, new HashMap<String, String>());
    }

    public EmailAlerter(SmtpServerSettings smtpServerSettings, SendSettings sendSettings, Map<String, String> standardTags) {
        this.smtpServerSettings = smtpServerSettings;
        this.sendSettings = sendSettings;
        this.standardTags = standardTags;
    }

    @Subscribe
    public void handleAlert(Alert alert) {
        String severity;
        String severityFilter = this.sendSettings.getSeverityFilter();
        if (!Pattern.matches(severityFilter, severity = alert.getSeverity().name())) {
            LOG.debug("suppressing alert message with severity {}, as it doesn't match the severity filter '{}'.", (Object)severity, (Object)severityFilter);
            return;
        }
        Alert taggedAlert = this.appendStandardTags(alert);
        String alertMessage = JsonUtils.toPrettyString(JsonUtils.toJson(taggedAlert));
        try {
            LOG.debug("sending alert to {}: {}", (Object)this.sendSettings.getRecipients(), (Object)alert);
            SmtpMessage email = new SmtpMessage(this.sendSettings.getRecipients(), this.sendSettings.getSender(), this.sendSettings.getSubject(), alertMessage, UtcTime.now());
            new SmtpSender(email, this.smtpServerSettings).call();
        }
        catch (Exception e) {
            LOG.error(String.format("failed to send alert message: %s\nAlert message was: %s", e.getMessage(), alertMessage), e);
        }
    }

    private Alert appendStandardTags(Alert alert) {
        for (Map.Entry<String, String> standardTag : this.standardTags.entrySet()) {
            alert = alert.withTag(standardTag.getKey(), standardTag.getValue());
        }
        return alert;
    }
}

