/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.smtp.alerter;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class SendSettings {
    public static final String DEFAULT_SEVERITY_FILTER = ".*";
    private final List<String> recipients;
    private final String sender;
    private final String subject;
    private final String severityFilter;

    public SendSettings(List<String> recipients, String sender, String subject, String severityFilter) {
        this.recipients = recipients;
        this.sender = sender;
        this.subject = subject;
        this.severityFilter = severityFilter;
        this.validate();
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSeverityFilter() {
        return Optional.fromNullable(this.severityFilter).or(DEFAULT_SEVERITY_FILTER);
    }

    public int hashCode() {
        return Objects.hashCode(this.recipients, this.sender, this.subject, this.getSeverityFilter());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SendSettings) {
            SendSettings that = (SendSettings)obj;
            return Objects.equal(this.recipients, that.recipients) && Objects.equal(this.sender, that.sender) && Objects.equal(this.subject, that.subject) && Objects.equal(this.getSeverityFilter(), that.getSeverityFilter());
        }
        return false;
    }

    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.recipients != null, "recipients list cannot be null");
        for (String recipient : this.recipients) {
            Preconditions.checkArgument(recipient != null, "recipient cannot be null");
            this.verifyEmailAddress(recipient);
        }
        Preconditions.checkArgument(this.sender != null, "sender cannot be null");
        this.verifyEmailAddress(this.sender);
        this.verifySeverityFilter(this.getSeverityFilter());
    }

    private void verifyEmailAddress(String address) {
        try {
            new InternetAddress(address, true);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(String.format("illegal email address '%s'", address));
        }
    }

    private void verifySeverityFilter(String severityFilter) {
        try {
            Pattern.compile(severityFilter);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("illegal severity filter expression: " + e.getMessage(), e);
        }
    }
}

