/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.ssh;

import com.elastisys.scale.commons.net.ssh.SshCommandResult;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommandRequester
implements Callable<SshCommandResult> {
    static final Logger logger = LoggerFactory.getLogger(SshCommandRequester.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private final String hostname;
    private final int sshPort;
    private final String username;
    private final String privateKeyPath;
    private final String script;
    private final int connectionTimeout;
    private final int readTimeout;

    public SshCommandRequester(String hostname, int sshPort, String username, String privateKeyPath, String script) {
        this(hostname, sshPort, username, privateKeyPath, script, 10000, 10000);
    }

    public SshCommandRequester(String hostname, int sshPort, String username, String privateKeyPath, String script, int connectionTimeout, int readTimeout) {
        this.hostname = hostname;
        this.sshPort = sshPort;
        this.username = username;
        this.privateKeyPath = privateKeyPath;
        this.script = script;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshCommandResult call() throws Exception {
        JSch ssh = new JSch();
        ssh.addIdentity(this.privateKeyPath);
        Session session = ssh.getSession(this.username, this.hostname, this.sshPort);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.setTimeout(this.readTimeout);
        session.connect(this.connectionTimeout);
        try {
            SshCommandResult sshCommandResult = this.execute(session, this.script);
            return sshCommandResult;
        }
        finally {
            session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SshCommandResult execute(Session session, String script) throws Exception {
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        try {
            SshCommandResult sshCommandResult;
            channel.setCommand(this.script);
            Closer closer = Closer.create();
            InputStream stdoutStream = channel.getInputStream();
            InputStream stderrStream = channel.getErrStream();
            Reader stdoutReader = closer.register(new InputStreamReader(stdoutStream, "UTF-8"));
            Reader stderrReader = closer.register(new InputStreamReader(stderrStream, "UTF-8"));
            try {
                channel.connect();
                String stdout = CharStreams.toString(stdoutReader);
                String stderr = CharStreams.toString(stderrReader);
                int exitStatus = channel.getExitStatus();
                sshCommandResult = new SshCommandResult(exitStatus, stdout, stderr);
            }
            catch (Throwable throwable) {
                closer.close();
                throw throwable;
            }
            closer.close();
            return sshCommandResult;
        }
        finally {
            channel.disconnect();
        }
    }
}

