/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.ssl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class BasicCredentials {
    private final String username;
    private final String password;

    public BasicCredentials(String username, String password) {
        Preconditions.checkArgument(username != null, "basic credentials missing username");
        Preconditions.checkArgument(password != null, "basic credentials missing password");
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hashCode(this.username, this.password);
    }

    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.username != null, "basic credentials missing username");
        Preconditions.checkArgument(this.password != null, "basic credentials missing password");
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicCredentials) {
            BasicCredentials that = (BasicCredentials)obj;
            return Objects.equal(this.username, that.username) && Objects.equal(this.password, that.password);
        }
        return false;
    }
}

