/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.ssl;

import com.elastisys.scale.commons.net.ssl.KeyStoreType;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;

public class CertificateCredentials {
    private static final KeyStoreType DEFAULT_KEYSTORE_TYPE = KeyStoreType.PKCS12;
    private final KeyStoreType keystoreType;
    private final String keystorePath;
    private final String keystorePassword;
    private final String keyPassword;

    public CertificateCredentials(String keystorePath, String keystorePassword) {
        this(DEFAULT_KEYSTORE_TYPE, keystorePath, keystorePassword, null);
    }

    public CertificateCredentials(KeyStoreType keystoreType, String keystorePath, String keystorePassword) {
        this(keystoreType, keystorePath, keystorePassword, null);
    }

    public CertificateCredentials(KeyStoreType keystoreType, String keystorePath, String keystorePassword, String keyPassword) {
        Preconditions.checkArgument(keystoreType != null, "certificate credentials missing keystore type");
        Preconditions.checkArgument(keystorePath != null, "certificate credentials missing keystore path");
        Preconditions.checkArgument(new File(keystorePath).isFile(), "certificate credentials keystore path '%s' is not a file", keystorePath);
        Preconditions.checkArgument(keystorePassword != null, "certificate credentials missing keystore password");
        this.keystoreType = keystoreType;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
    }

    public KeyStoreType getKeystoreType() {
        return Optional.fromNullable(this.keystoreType).or(DEFAULT_KEYSTORE_TYPE);
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public Optional<String> getKeyPassword() {
        return Optional.fromNullable(this.keyPassword);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.getKeystoreType(), this.keystorePath, this.keystorePassword, this.keyPassword});
    }

    public boolean equals(Object obj) {
        if (obj instanceof CertificateCredentials) {
            CertificateCredentials that = (CertificateCredentials)obj;
            return Objects.equal((Object)this.getKeystoreType(), (Object)that.getKeystoreType()) && Objects.equal(this.keystorePath, that.keystorePath) && Objects.equal(this.keystorePassword, that.keystorePassword) && Objects.equal(this.keyPassword, that.keyPassword);
        }
        return false;
    }

    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.keystorePath != null, "certificate credentials missing keystore path");
        Preconditions.checkArgument(new File(this.keystorePath).isFile(), "certificate credentials keystore path '%s' is not a file", this.keystorePath);
        Preconditions.checkArgument(this.keystorePassword != null, "certificate credentials missing keystore password");
    }
}

