/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.ssl;

import com.elastisys.scale.commons.net.ssl.SslUtils;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslContextBuilder {
    private Optional<KeyManagerFactory> keyManagerFactory = Optional.absent();
    private Optional<List<TrustManager>> trustManagers = Optional.absent();

    private SslContextBuilder() {
    }

    public static SslContextBuilder newBuilder() {
        return new SslContextBuilder();
    }

    public SSLContext build() throws RuntimeException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyManager[] keyManagers = new KeyManager[]{};
            if (this.keyManagerFactory.isPresent()) {
                keyManagers = this.keyManagerFactory.get().getKeyManagers();
            }
            TrustManager[] trustManagers = new TrustManager[]{SslUtils.insecureTrustManager()};
            if (this.trustManagers.isPresent()) {
                trustManagers = this.trustManagers.get().toArray(new TrustManager[0]);
            }
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public SslContextBuilder noClientAuthentication() {
        this.keyManagerFactory = Optional.absent();
        return this;
    }

    public SslContextBuilder clientAuthentication(KeyStore keyStore, String password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password.toCharArray());
        this.keyManagerFactory = Optional.of(keyManagerFactory);
        return this;
    }

    public SslContextBuilder noServerAuthentication() {
        ArrayList<TrustManager> insecureTrustManager = Lists.newArrayList(SslUtils.insecureTrustManager());
        this.trustManagers = Optional.of(insecureTrustManager);
        return this;
    }

    public SslContextBuilder serverAuthentication(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        ArrayList<TrustManager> trustManagerList = Lists.newArrayList(trustManagers);
        this.trustManagers = Optional.of(trustManagerList);
        return this;
    }
}

