/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.rest.client;

import com.elastisys.scale.commons.net.ssl.SslContextBuilder;
import com.elastisys.scale.commons.net.ssl.SslUtils;
import com.elastisys.scale.commons.rest.converters.JsonObjectMapperProvider;
import com.elastisys.scale.commons.rest.converters.JsonObjectMessageBodyReader;
import com.elastisys.scale.commons.rest.converters.JsonObjectMessageBodyWriter;
import com.google.common.base.Throwables;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;

public class RestClients {
    public static Client httpsNoAuth() {
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().sslContext(SslUtils.trustAllCertsSslContext()).hostnameVerifier(SslUtils.allowAllHostNames()).register(JsonObjectMessageBodyWriter.class)).register(JsonObjectMessageBodyReader.class)).build();
        client.register(JacksonFeature.class);
        client.register(JsonObjectMapperProvider.class);
        return client;
    }

    public static Client httpsBasicAuth(String userName, String password) {
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().sslContext(SslUtils.trustAllCertsSslContext()).hostnameVerifier(SslUtils.allowAllHostNames()).register(JsonObjectMessageBodyWriter.class)).register(JsonObjectMessageBodyReader.class)).build();
        client.register(JacksonFeature.class);
        client.register(JsonObjectMapperProvider.class);
        client.register(HttpAuthenticationFeature.basic(userName, password));
        return client;
    }

    public static Client httpsCertAuth(KeyStore keystore, String password) throws RuntimeException {
        try {
            SSLContext clientCertSslContext = SslContextBuilder.newBuilder().clientAuthentication(keystore, password).noServerAuthentication().build();
            Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().sslContext(clientCertSslContext).hostnameVerifier(SslUtils.allowAllHostNames()).register(JsonObjectMessageBodyWriter.class)).register(JsonObjectMessageBodyReader.class)).build();
            client.register(JacksonFeature.class);
            client.register(JsonObjectMapperProvider.class);
            return client;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static Client httpBasicAuth(String userName, String password) {
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JsonObjectMessageBodyWriter.class)).register(JsonObjectMessageBodyReader.class)).build();
        client.register(JacksonFeature.class);
        client.register(JsonObjectMapperProvider.class);
        client.register(HttpAuthenticationFeature.basic(userName, password));
        return client;
    }

    public static Client httpNoAuth() {
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JsonObjectMessageBodyWriter.class)).register(JsonObjectMessageBodyReader.class)).build();
        client.register(JacksonFeature.class);
        client.register(JsonObjectMapperProvider.class);
        return client;
    }
}

