/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.rest.converters;

import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.rest.types.ErrorType;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json"})
public class JsonObjectMessageBodyReader
implements MessageBodyReader<JsonObject> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonObject.class.isAssignableFrom(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonObject readFrom(Class<JsonObject> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try (InputStreamReader entityReader = new InputStreamReader(entityStream, Charsets.UTF_8);){
            String entity = CharStreams.toString(entityReader);
            Preconditions.checkArgument(entity != null, "failed to parse JSON object: entity stream is null");
            Preconditions.checkArgument(!entity.isEmpty(), "failed to parse JSON object: entity stream is empty");
            JsonObject jsonObject = JsonUtils.parseJsonString(entity);
            return jsonObject;
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.status(Response.Status.BAD_REQUEST).entity(new ErrorType(e)).build());
        }
        catch (JsonParseException e) {
            throw new WebApplicationException((Throwable)e, Response.status(Response.Status.BAD_REQUEST).entity(new ErrorType(e)).build());
        }
    }
}

