/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.server;

import com.elastisys.scale.commons.server.SslKeyStoreType;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class BaseServerBuilder {
    private Integer httpPort = null;
    private Integer httpsPort = null;
    private String sslKeyStorePath = null;
    private SslKeyStoreType sslKeyStoreType = SslKeyStoreType.PKCS12;
    private String sslKeyStorePassword = null;
    private String sslKeyPassword = null;
    private String sslTrustStorePath = null;
    private SslKeyStoreType sslTrustStoreType = SslKeyStoreType.JKS;
    private String sslTrustStorePassword = null;
    private boolean sslRequireClientCert = false;

    protected BaseServerBuilder() {
    }

    public static BaseServerBuilder create() {
        return new BaseServerBuilder();
    }

    public Server build() {
        Server server = new Server();
        if (this.httpPort != null) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            if (this.httpsPort != null) {
                httpConfig.setSecureScheme("https");
                httpConfig.setSecurePort(this.httpsPort);
            }
            httpConfig.setOutputBufferSize(32768);
            ServerConnector http = new ServerConnector(server, new HttpConnectionFactory(httpConfig));
            http.setPort(this.httpPort);
            server.addConnector(http);
        }
        if (this.httpsPort != null) {
            BaseServerBuilder.checkArgument(this.sslKeyStoreType != null, "https configuration missing key store type is null");
            BaseServerBuilder.checkArgument(this.sslKeyStorePath != null, "https configuration missing SSL key store path");
            BaseServerBuilder.checkArgument(this.sslKeyStorePassword != null, "https configuration missing SSL key store password");
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStoreType(this.sslKeyStoreType.name());
            sslContextFactory.setKeyStorePath(this.sslKeyStorePath);
            sslContextFactory.setKeyStorePassword(this.sslKeyStorePassword);
            if (this.sslKeyPassword != null) {
                sslContextFactory.setKeyManagerPassword(this.sslKeyPassword);
            } else {
                sslContextFactory.setKeyManagerPassword(this.sslKeyStorePassword);
            }
            sslContextFactory.addExcludeProtocols("SSLv3");
            if (this.sslTrustStorePath != null) {
                BaseServerBuilder.checkArgument(this.sslTrustStoreType != null, "missing trust store type for trust store");
                BaseServerBuilder.checkArgument(this.sslTrustStorePassword != null, "missing password for trust store");
                sslContextFactory.setTrustStoreType(this.sslTrustStoreType.name());
                sslContextFactory.setTrustStorePath(this.sslTrustStorePath);
                sslContextFactory.setTrustStorePassword(this.sslTrustStorePassword);
            }
            if (this.sslRequireClientCert) {
                BaseServerBuilder.checkArgument(this.sslTrustStorePath != null, "Client certificate authentication specified without specifying a trust store");
                BaseServerBuilder.checkArgument(this.sslTrustStorePassword != null, "Client certificate authentication specified without specifying a trust store password");
            }
            sslContextFactory.setNeedClientAuth(this.sslRequireClientCert);
            sslContextFactory.setWantClientAuth(false);
            HttpConfiguration httpsConfig = new HttpConfiguration();
            httpsConfig.addCustomizer(new SecureRequestCustomizer());
            httpsConfig.setOutputBufferSize(32768);
            ServerConnector https = new ServerConnector(server, new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfig));
            https.setPort(this.httpsPort);
            server.addConnector(https);
        }
        return server;
    }

    public BaseServerBuilder httpPort(Integer port) {
        this.httpPort = port;
        return this;
    }

    public BaseServerBuilder httpsPort(Integer port) {
        this.httpsPort = port;
        return this;
    }

    public BaseServerBuilder sslKeyStorePath(String pathOrUri) {
        this.sslKeyStorePath = pathOrUri;
        return this;
    }

    public BaseServerBuilder sslKeyStoreType(SslKeyStoreType type) {
        this.sslKeyStoreType = type;
        return this;
    }

    public BaseServerBuilder sslKeyStorePassword(String password) {
        this.sslKeyStorePassword = password;
        return this;
    }

    public BaseServerBuilder sslKeyPassword(String password) {
        this.sslKeyPassword = password;
        return this;
    }

    public BaseServerBuilder sslTrustStorePath(String pathOrUri) {
        this.sslTrustStorePath = pathOrUri;
        return this;
    }

    public BaseServerBuilder sslTrustStoreType(SslKeyStoreType type) {
        this.sslTrustStoreType = type;
        return this;
    }

    public BaseServerBuilder sslTrustStorePassword(String password) {
        this.sslTrustStorePassword = password;
        return this;
    }

    public BaseServerBuilder sslRequireClientCert(boolean requireCertAuthentication) {
        this.sslRequireClientCert = requireCertAuthentication;
        return this;
    }

    static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }
}

