/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.server;

import com.elastisys.scale.commons.server.BaseServerBuilder;
import java.io.File;
import javax.servlet.Servlet;

public class ServletDefinition {
    private final Servlet servlet;
    private final String servletPath;
    private final boolean requireHttps;
    private final boolean requireBasicAuth;
    private final String realmFile;
    private final String requireRole;

    private ServletDefinition(Servlet servlet, String servletPath, boolean requireHttps, boolean requireBasicAuth, String realmFile, String requireRole) {
        this.servlet = servlet;
        this.servletPath = servletPath;
        this.requireHttps = requireHttps;
        this.requireBasicAuth = requireBasicAuth;
        this.realmFile = realmFile;
        this.requireRole = requireRole;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public boolean isRequireHttps() {
        return this.requireHttps;
    }

    public boolean isRequireBasicAuth() {
        return this.requireBasicAuth;
    }

    public String getRealmFile() {
        return this.realmFile;
    }

    public String getRequireRole() {
        return this.requireRole;
    }

    public static class Builder {
        private Servlet servlet = null;
        private String servletPath = "/";
        private boolean requireHttps = false;
        private boolean requireBasicAuth = false;
        private String realmFile = null;
        private String requireRole = null;

        public ServletDefinition build() {
            BaseServerBuilder.checkArgument(this.servlet != null, "missing servlet");
            BaseServerBuilder.checkArgument(this.servletPath != null, "missing a servlet path");
            this.validateSecurityConfig();
            return new ServletDefinition(this.servlet, this.servletPath, this.requireHttps, this.requireBasicAuth, this.realmFile, this.requireRole);
        }

        private void validateSecurityConfig() {
            if (this.requireBasicAuth) {
                BaseServerBuilder.checkArgument(this.realmFile != null, "a security realm file must be specified when basic authentication is specified");
                BaseServerBuilder.checkArgument(new File(this.realmFile).isFile(), String.format("specified security realm file '%s' is not a valid file", this.realmFile));
                BaseServerBuilder.checkArgument(this.requireRole != null, "a required user role must be specified when basic authentication is specified");
            }
        }

        public Builder servlet(Servlet servlet) {
            this.servlet = servlet;
            return this;
        }

        public Builder servletPath(String servletPath) {
            this.servletPath = servletPath;
            return this;
        }

        public Builder requireHttps(boolean requireSecureAccess) {
            this.requireHttps = requireSecureAccess;
            return this;
        }

        public Builder requireBasicAuth(boolean requireBasicAuth) {
            this.requireBasicAuth = requireBasicAuth;
            return this;
        }

        public Builder realmFile(String realmFile) {
            this.realmFile = realmFile;
            return this;
        }

        public Builder requireRole(String role) {
            this.requireRole = role;
            return this;
        }
    }
}

