/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.server;

import com.elastisys.scale.commons.server.BaseServerBuilder;
import com.elastisys.scale.commons.server.ServletDefinition;
import com.elastisys.scale.commons.server.SslKeyStoreType;
import com.google.common.collect.Lists;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletServerBuilder {
    static Logger LOG = LoggerFactory.getLogger(ServletServerBuilder.class);
    private BaseServerBuilder baseServerBuilder;
    private List<ServletDefinition> servletDefinitions = Lists.newArrayList();

    protected ServletServerBuilder(BaseServerBuilder serverBuilder) {
        this.baseServerBuilder = serverBuilder;
    }

    public static ServletServerBuilder create() {
        return new ServletServerBuilder(BaseServerBuilder.create());
    }

    public Server build() {
        Server server = this.baseServerBuilder.build();
        HandlerList servletHandlers = new HandlerList();
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            ServletContextHandler servletHandler = this.createServletHandler(servletDefinition);
            if (servletDefinition.isRequireHttps() || servletDefinition.isRequireBasicAuth()) {
                ConstraintSecurityHandler securityHandler = this.createSecurityHandler(server, servletDefinition);
                servletHandler.setSecurityHandler(securityHandler);
            }
            servletHandlers.addHandler(servletHandler);
        }
        server.setHandler(servletHandlers);
        return server;
    }

    private ConstraintSecurityHandler createSecurityHandler(Server server, ServletDefinition servletDefinition) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setServer(server);
        Constraint constraint = new Constraint();
        constraint.setName("security" + servletDefinition.hashCode());
        if (servletDefinition.isRequireBasicAuth()) {
            HashLoginService loginService = new HashLoginService("elastisys:scale security realm", servletDefinition.getRealmFile());
            securityHandler.getServer().addBean(loginService);
            securityHandler.setAuthenticator(new BasicAuthenticator());
            securityHandler.setLoginService(loginService);
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{servletDefinition.getRequireRole()});
        }
        if (servletDefinition.isRequireHttps()) {
            constraint.setDataConstraint(2);
        }
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        securityHandler.setConstraintMappings(Lists.newArrayList(mapping));
        return securityHandler;
    }

    public ServletServerBuilder addServlet(ServletDefinition servletDefinition) {
        this.servletDefinitions.add(servletDefinition);
        return this;
    }

    private ServletContextHandler createServletHandler(ServletDefinition servletDefinition) {
        Servlet servlet = servletDefinition.getServlet();
        String servletPath = servletDefinition.getServletPath();
        ServletContextHandler servletHandler = new ServletContextHandler(1);
        servletHandler.setContextPath(servletPath);
        String pathSpec = "/*";
        servletHandler.addServlet(new ServletHolder(servlet), pathSpec);
        LOG.debug("adding servlet '{}' at context path '{}' with path spec '{}'", servlet, servletPath, pathSpec);
        return servletHandler;
    }

    public ServletServerBuilder httpPort(Integer port) {
        this.baseServerBuilder.httpPort(port);
        return this;
    }

    public ServletServerBuilder httpsPort(Integer port) {
        this.baseServerBuilder.httpsPort(port);
        return this;
    }

    public ServletServerBuilder sslKeyStorePath(String pathOrUri) {
        this.baseServerBuilder.sslKeyStorePath(pathOrUri);
        return this;
    }

    public ServletServerBuilder sslKeyStoreType(SslKeyStoreType type) {
        this.baseServerBuilder.sslKeyStoreType(type);
        return this;
    }

    public ServletServerBuilder sslKeyStorePassword(String password) {
        this.baseServerBuilder.sslKeyStorePassword(password);
        return this;
    }

    public ServletServerBuilder sslKeyPassword(String password) {
        this.baseServerBuilder.sslKeyPassword(password);
        return this;
    }

    public ServletServerBuilder sslTrustStorePath(String pathOrUri) {
        this.baseServerBuilder.sslTrustStorePath(pathOrUri);
        return this;
    }

    public ServletServerBuilder sslTrustStoreType(SslKeyStoreType type) {
        this.baseServerBuilder.sslTrustStoreType(type);
        return this;
    }

    public ServletServerBuilder sslTrustStorePassword(String password) {
        this.baseServerBuilder.sslTrustStorePassword(password);
        return this;
    }

    public ServletServerBuilder sslRequireClientCert(boolean requireCertAuthentication) {
        this.baseServerBuilder.sslRequireClientCert(requireCertAuthentication);
        return this;
    }
}

