/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.util.concurrent;

import com.elastisys.scale.commons.util.concurrent.RestartableScheduledExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class StandardRestartableScheduledExecutorService
implements RestartableScheduledExecutorService {
    private final int corePoolSize;
    private final ThreadFactory threadFactory;
    private ScheduledExecutorService executorService;

    public StandardRestartableScheduledExecutorService(int corePoolSize) {
        this(corePoolSize, Executors.defaultThreadFactory());
    }

    public StandardRestartableScheduledExecutorService(int corePoolSize, ThreadFactory threadFactory) {
        this.corePoolSize = corePoolSize;
        this.threadFactory = threadFactory;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.executorService = Executors.newScheduledThreadPool(this.corePoolSize, this.threadFactory);
    }

    @Override
    public void stop(int taskTerminationGracePeriod) throws InterruptedException {
        if (!this.isStarted()) {
            return;
        }
        this.executorService.shutdown();
        boolean allDone = this.executorService.awaitTermination(taskTerminationGracePeriod, TimeUnit.SECONDS);
        if (!allDone) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
    }

    @Override
    public boolean isStarted() {
        return this.executorService != null;
    }

    ExecutorService innerExecutor() {
        return this.executorService;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executorService.schedule(command, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executorService.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.executorService = null;
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> remainingTasks = this.executorService.shutdownNow();
        this.executorService = null;
        return remainingTasks;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executorService.invokeAny(tasks, timeout, unit);
    }
}

