/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.util.concurrent;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Waiter<T> {
    private T value;
    private final Lock valueLock = new ReentrantLock();
    private final Condition valueSet = this.valueLock.newCondition();

    public Waiter() {
        this.value = null;
    }

    public Waiter(T value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        Preconditions.checkNotNull(value, "attempt to set null value");
        this.valueLock.lock();
        try {
            this.value = value;
            this.valueSet.signal();
        }
        finally {
            this.valueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T await() throws InterruptedException {
        this.valueLock.lock();
        try {
            while (this.value == null) {
                this.valueSet.await();
            }
        }
        finally {
            this.valueLock.unlock();
        }
        return this.value;
    }
}

