/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.util.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException("Utility class not intended to be instantiated");
    }

    public static void deleteRecursively(File dirEntry) throws IOException {
        File[] files;
        Preconditions.checkNotNull(dirEntry, "null directory entry");
        if (!dirEntry.exists()) {
            return;
        }
        if (dirEntry.isDirectory() && (files = dirEntry.listFiles()) != null) {
            for (File file : files) {
                FileUtils.deleteRecursively(file);
            }
        }
        if (!dirEntry.delete()) {
            throw new IOException("Failed to delete file: " + dirEntry.getAbsolutePath());
        }
    }

    public static List<File> listDirectories(File directory) {
        Preconditions.checkNotNull(directory, "directory argument is null");
        Preconditions.checkArgument(directory.isDirectory(), "%s is not a directory", directory);
        File[] directories = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        return Arrays.asList(directories);
    }

    public static File cwd() {
        return new File(System.getProperty("user.dir"));
    }
}

