/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.util.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;

public class IoUtils {
    private IoUtils() {
        throw new UnsupportedOperationException("not intended to be instantiated");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(InputStream inputStream, Charset charset) {
        Preconditions.checkNotNull(inputStream, "null inputStream not allowed");
        Preconditions.checkNotNull(charset, "null charset not allowed");
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            String string = CharStreams.toString(reader);
            return string;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static String toString(File file, Charset charset) {
        Preconditions.checkNotNull(file, "null file not allowed");
        Preconditions.checkNotNull(charset, "null charset not allowed");
        try {
            return IoUtils.toString(new FileInputStream(file), charset);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static String toString(String resourceName, Charset charset) {
        Preconditions.checkNotNull(resourceName, "null resourceName not allowed");
        Preconditions.checkNotNull(charset, "null charset not allowed");
        try {
            URL resourceUrl = Resources.getResource(resourceName);
            return IoUtils.toString(resourceUrl.openStream(), charset);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

