/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.util.strings;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;

public class StringUtils {
    private StringUtils() {
        throw new UnsupportedOperationException(StringUtils.class.getName() + " not instantiable");
    }

    public static String replaceAll(String string, Map<String, String> substitutions) {
        for (Map.Entry<String, String> substitution : substitutions.entrySet()) {
            String pattern = substitution.getKey();
            String replacement = Optional.fromNullable(substitution.getValue()).or("null");
            string = string.replace(pattern, replacement);
        }
        return string;
    }

    public static Function<String, String> prepend(String prefix) {
        return new StringPrependFunction(prefix);
    }

    public static class StringPrependFunction
    implements Function<String, String> {
        private final String prefix;

        public StringPrependFunction(String prefix) {
            Preconditions.checkArgument(prefix != null, "null prefix");
            this.prefix = prefix;
        }

        @Override
        public String apply(String input) {
            return this.prefix + input;
        }
    }
}

