/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CompletableCallback;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler<ByteBuffer> {
    private final HttpParser parser = new HttpParser(this);
    private ByteBuffer buffer;
    private boolean shutdown;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    public void receive() {
        HttpClient client = this.getHttpDestination().getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        this.buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
        this.process();
    }

    private void process() {
        if (this.readAndParse()) {
            HttpClient client = this.getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            bufferPool.release(this.buffer);
            this.buffer = null;
        }
    }

    private boolean readAndParse() {
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        EndPoint endPoint = connection.getEndPoint();
        ByteBuffer buffer = this.buffer;
        try {
            int read;
            block9: {
                do {
                    if (connection.isClosed()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} closed", connection);
                        }
                        return true;
                    }
                    if (!this.parse(buffer)) {
                        return false;
                    }
                    read = endPoint.fill(buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes from {}", read, endPoint);
                    }
                    if (read <= 0) break block9;
                } while (this.parse(buffer));
                return false;
            }
            if (read == 0) {
                this.fillInterested();
                return true;
            }
            this.shutdown();
            return true;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            this.failAndClose(x);
            return true;
        }
    }

    private boolean parse(ByteBuffer buffer) {
        if (this.parser.parseNext(buffer)) {
            return this.parser.isStart();
        }
        return true;
    }

    private void fillInterested() {
        this.getHttpChannel().getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public int getHeaderCacheSize() {
        return 256;
    }

    @Override
    public boolean startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        String method = exchange.getRequest().getMethod();
        this.parser.setHeadResponse(HttpMethod.HEAD.is(method) || HttpMethod.CONNECT.is(method));
        exchange.getResponse().version(version).status(status).reason(reason);
        this.responseBegin(exchange);
        return false;
    }

    @Override
    public boolean parsedHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseHeader(exchange, field);
        return false;
    }

    @Override
    public boolean headerComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseHeaders(exchange);
        return false;
    }

    @Override
    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        CompletableCallback callback = new CompletableCallback(){

            @Override
            public void resume() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content consumed asynchronously, resuming processing", new Object[0]);
                }
                HttpReceiverOverHTTP.this.process();
            }

            @Override
            public void abort(Throwable x) {
                HttpReceiverOverHTTP.this.failAndClose(x);
            }
        };
        this.responseContent(exchange, buffer, callback);
        return callback.tryComplete();
    }

    @Override
    public boolean messageComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseSuccess(exchange);
        return true;
    }

    @Override
    public void earlyEOF() {
        HttpExchange exchange = this.getHttpExchange();
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        if (exchange == null) {
            connection.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(connection)));
        }
    }

    @Override
    public void badMessage(int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            HttpResponse response = exchange.getResponse();
            response.status(status).reason(reason);
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + this.getHttpConnection(), response));
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.parser.close();
    }

    private void failAndClose(Throwable failure) {
        if (this.responseFailure(failure)) {
            this.getHttpConnection().close(failure);
        }
    }

    public String toString() {
        return String.format("%s@%x on %s", this.getClass().getSimpleName(), this.hashCode(), this.getHttpConnection());
    }
}

