/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jclouds.util.Closeables2;

public class ExecChannel
implements Closeable {
    private final OutputStream input;
    private final InputStream output;
    private final InputStream error;
    private final Supplier<Integer> exitStatus;
    private final Closeable closer;

    public ExecChannel(OutputStream input, InputStream output, InputStream error, Supplier<Integer> exitStatus, Closeable closer) {
        this.input = Preconditions.checkNotNull(input, "input");
        this.output = Preconditions.checkNotNull(output, "output");
        this.error = Preconditions.checkNotNull(error, "error");
        this.exitStatus = Preconditions.checkNotNull(exitStatus, "exitStatus");
        this.closer = Preconditions.checkNotNull(closer, "closer");
    }

    public OutputStream getInput() {
        return this.input;
    }

    public InputStream getError() {
        return this.error;
    }

    public InputStream getOutput() {
        return this.output;
    }

    public Supplier<Integer> getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public void close() throws IOException {
        Closeables2.closeQuietly(this.input);
        Closeables2.closeQuietly(this.output);
        Closeables2.closeQuietly(this.error);
        this.closer.close();
    }
}

