/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.ImageImpl;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class ImageBuilder
extends ComputeMetadataBuilder {
    private OperatingSystem operatingSystem;
    private Image.Status status;
    private String backendStatus;
    private String version;
    private String description;
    private LoginCredentials defaultLoginCredentials;

    public ImageBuilder() {
        super(ComputeType.IMAGE);
    }

    public ImageBuilder operatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = Preconditions.checkNotNull(operatingSystem, "operatingSystem");
        return this;
    }

    public ImageBuilder status(Image.Status status) {
        this.status = Preconditions.checkNotNull(status, "status");
        return this;
    }

    public ImageBuilder backendStatus(@Nullable String backendStatus) {
        this.backendStatus = backendStatus;
        return this;
    }

    public ImageBuilder version(@Nullable String version) {
        this.version = version;
        return this;
    }

    public ImageBuilder description(@Nullable String description) {
        this.description = description;
        return this;
    }

    public ImageBuilder defaultCredentials(@Nullable LoginCredentials defaultLoginCredentials) {
        this.defaultLoginCredentials = defaultLoginCredentials;
        return this;
    }

    @Override
    public ImageBuilder id(String id) {
        return (ImageBuilder)ImageBuilder.class.cast(super.id(id));
    }

    @Override
    public ImageBuilder tags(Iterable<String> tags) {
        return (ImageBuilder)ImageBuilder.class.cast(super.tags(tags));
    }

    @Override
    public ImageBuilder ids(String id) {
        return (ImageBuilder)ImageBuilder.class.cast(super.ids(id));
    }

    @Override
    public ImageBuilder providerId(String providerId) {
        return (ImageBuilder)ImageBuilder.class.cast(super.providerId(providerId));
    }

    @Override
    public ImageBuilder name(String name) {
        return (ImageBuilder)ImageBuilder.class.cast(super.name(name));
    }

    @Override
    public ImageBuilder location(Location location) {
        return (ImageBuilder)ImageBuilder.class.cast(super.location(location));
    }

    @Override
    public ImageBuilder uri(URI uri) {
        return (ImageBuilder)ImageBuilder.class.cast(super.uri(uri));
    }

    @Override
    public ImageBuilder userMetadata(Map<String, String> userMetadata) {
        return (ImageBuilder)ImageBuilder.class.cast(super.userMetadata((Map)userMetadata));
    }

    @Override
    public Image build() {
        return new ImageImpl(this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.tags, this.operatingSystem, this.status, this.backendStatus, this.description, this.version, this.defaultLoginCredentials);
    }

    public static ImageBuilder fromImage(Image image) {
        return ((ImageBuilder)((ImageBuilder)new ImageBuilder().providerId(image.getProviderId()).name(image.getName()).id(image.getId()).location(image.getLocation()).uri(image.getUri()).userMetadata((Map)image.getUserMetadata())).tags(image.getTags())).version(image.getVersion()).description(image.getDescription()).operatingSystem(image.getOperatingSystem()).status((Image.Status)((Object)image.getStatus())).backendStatus(image.getBackendStatus()).defaultCredentials(image.getDefaultCredentials());
    }
}

