/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.stub.extensions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class StubSecurityGroupExtension
implements SecurityGroupExtension {
    private final Supplier<Location> location;
    private final Provider<Integer> groupIdProvider;
    private final ConcurrentMap<String, SecurityGroup> groups;
    private final Multimap<String, SecurityGroup> groupsForNodes;

    @Inject
    public StubSecurityGroupExtension(ConcurrentMap<String, SecurityGroup> groups, Supplier<Location> location, @Named(value="GROUP_ID") Provider<Integer> groupIdProvider, Multimap<String, SecurityGroup> groupsForNodes) {
        this.groups = groups;
        this.location = location;
        this.groupIdProvider = groupIdProvider;
        this.groupsForNodes = groupsForNodes;
    }

    @Override
    public Set<SecurityGroup> listSecurityGroups() {
        return ImmutableSet.copyOf(this.groups.values());
    }

    @Override
    public Set<SecurityGroup> listSecurityGroupsInLocation(final Location location) {
        return ImmutableSet.copyOf(Iterables.filter(this.groups.values(), new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup group) {
                return group.getLocation().equals(location);
            }
        }));
    }

    @Override
    public Set<SecurityGroup> listSecurityGroupsForNode(String nodeId) {
        return ImmutableSet.copyOf(this.groupsForNodes.get(nodeId));
    }

    @Override
    public SecurityGroup getSecurityGroupById(String id) {
        return (SecurityGroup)this.groups.get(id);
    }

    @Override
    public SecurityGroup createSecurityGroup(String name, Location location) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        String id = this.groupIdProvider.get() + "";
        builder.ids(id);
        builder.name(name);
        builder.location(location);
        SecurityGroup group = builder.build();
        this.groups.put(group.getId(), group);
        return group;
    }

    @Override
    public boolean removeSecurityGroup(String id) {
        if (this.groups.containsKey(id)) {
            this.groups.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public SecurityGroup addIpPermission(IpPermission ipPermission, SecurityGroup group) {
        SecurityGroupBuilder builder = SecurityGroupBuilder.fromSecurityGroup(Preconditions.checkNotNull(group, "group"));
        builder.ipPermission(Preconditions.checkNotNull(ipPermission, "ipPermission"));
        SecurityGroup newGroup = builder.build();
        if (this.groups.containsKey(newGroup.getId())) {
            this.groups.remove(newGroup.getId());
        }
        this.groups.put(newGroup.getId(), newGroup);
        return newGroup;
    }

    @Override
    public SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder ipBuilder = IpPermission.builder();
        ipBuilder.ipProtocol(protocol);
        ipBuilder.fromPort(startPort);
        ipBuilder.toPort(endPort);
        if (tenantIdGroupNamePairs.size() > 0) {
            ipBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        }
        if (Iterables.size(ipRanges) > 0) {
            ipBuilder.cidrBlocks(ipRanges);
        }
        if (Iterables.size(groupIds) > 0) {
            ipBuilder.groupIds(groupIds);
        }
        IpPermission perm = ipBuilder.build();
        SecurityGroupBuilder builder = SecurityGroupBuilder.fromSecurityGroup(Preconditions.checkNotNull(group, "group"));
        builder.ipPermission(perm);
        SecurityGroup newGroup = builder.build();
        if (this.groups.containsKey(newGroup.getId())) {
            this.groups.remove(newGroup.getId());
        }
        this.groups.put(newGroup.getId(), newGroup);
        return newGroup;
    }

    @Override
    public SecurityGroup removeIpPermission(IpPermission ipPermission, SecurityGroup group) {
        SecurityGroupBuilder builder = SecurityGroupBuilder.fromSecurityGroup(Preconditions.checkNotNull(group, "group"));
        builder.ipPermissions();
        builder.ipPermissions(Iterables.filter(group.getIpPermissions(), Predicates.not(Predicates.equalTo(ipPermission))));
        SecurityGroup newGroup = builder.build();
        if (this.groups.containsKey(newGroup.getId())) {
            this.groups.remove(newGroup.getId());
        }
        this.groups.put(newGroup.getId(), newGroup);
        return newGroup;
    }

    @Override
    public SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder ipBuilder = IpPermission.builder();
        ipBuilder.ipProtocol(protocol);
        ipBuilder.fromPort(startPort);
        ipBuilder.toPort(endPort);
        if (tenantIdGroupNamePairs.size() > 0) {
            ipBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        }
        if (Iterables.size(ipRanges) > 0) {
            ipBuilder.cidrBlocks(ipRanges);
        }
        if (Iterables.size(groupIds) > 0) {
            ipBuilder.groupIds(groupIds);
        }
        IpPermission perm = ipBuilder.build();
        SecurityGroupBuilder builder = SecurityGroupBuilder.fromSecurityGroup(Preconditions.checkNotNull(group, "group"));
        builder.ipPermissions();
        builder.ipPermissions(Iterables.filter(group.getIpPermissions(), Predicates.not(Predicates.equalTo(perm))));
        SecurityGroup newGroup = builder.build();
        if (this.groups.containsKey(newGroup.getId())) {
            this.groups.remove(newGroup.getId());
        }
        this.groups.put(newGroup.getId(), newGroup);
        return newGroup;
    }

    @Override
    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    @Override
    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    @Override
    public boolean supportsGroupIds() {
        return true;
    }

    @Override
    public boolean supportsPortRangesForGroups() {
        return true;
    }
}

