/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;

@Singleton
public class ImageCacheSupplier
implements Supplier<Set<? extends Image>> {
    private final Supplier<Set<? extends Image>> imageCache;
    private final Cache<String, Image> uncachedImages;

    @Inject
    public ImageCacheSupplier(@Named(value="imageCache") Supplier<Set<? extends Image>> imageCache, @Named(value="jclouds.session-interval") long sessionIntervalSeconds) {
        this.imageCache = Preconditions.checkNotNull(imageCache, "imageCache");
        this.uncachedImages = CacheBuilder.newBuilder().expireAfterWrite(sessionIntervalSeconds, TimeUnit.SECONDS).build();
    }

    @Override
    public Set<? extends Image> get() {
        return ImmutableSet.copyOf(Iterables.concat((Iterable)this.imageCache.get(), this.uncachedImages.asMap().values()));
    }

    public void registerImage(Image image) {
        Preconditions.checkNotNull(image, "image");
        this.uncachedImages.put(image.getId(), image);
    }
}

