/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.io.payloads.InputStreamPayload;

@Singleton
public class BasePayloadSlicer
implements PayloadSlicer {
    @Override
    public Payload slice(Payload input, long offset, long length) {
        Preconditions.checkNotNull(input);
        Preconditions.checkArgument(offset >= 0L, "offset is negative");
        Preconditions.checkArgument(length >= 0L, "length is negative");
        Payload returnVal = input.getRawContent() instanceof File ? this.doSlice((File)input.getRawContent(), offset, length) : (input.getRawContent() instanceof String ? this.doSlice((String)input.getRawContent(), offset, length) : (input.getRawContent() instanceof byte[] ? this.doSlice((byte[])input.getRawContent(), offset, length) : (input.getRawContent() instanceof InputStream ? this.doSlice((InputStream)input.getRawContent(), offset, length) : (input.getRawContent() instanceof ByteSource ? this.doSlice((ByteSource)input.getRawContent(), offset, length) : this.doSlice(input, offset, length)))));
        return this.copyMetadataAndSetLength(input, returnVal, length);
    }

    protected Payload doSlice(Payload content, long offset, long length) {
        return this.doSlice(ByteStreams2.asByteSource(content), offset, length);
    }

    protected Payload doSlice(String content, long offset, long length) {
        return this.doSlice(content.getBytes(), offset, length);
    }

    protected Payload doSlice(File content, long offset, long length) {
        return this.doSlice(Files.asByteSource(content), offset, length);
    }

    protected Payload doSlice(InputStream content, long offset, long length) {
        try {
            ByteStreams.skipFully(content, offset);
        }
        catch (IOException ioe) {
            throw Throwables.propagate(ioe);
        }
        return new InputStreamPayload(ByteStreams.limit(content, length));
    }

    protected Payload doSlice(ByteSource content, long offset, long length) {
        return new ByteSourcePayload(content.slice(offset, length));
    }

    protected Payload doSlice(byte[] content, long offset, long length) {
        Preconditions.checkArgument(offset <= Integer.MAX_VALUE, "offset is too big for an array");
        Preconditions.checkArgument(length <= Integer.MAX_VALUE, "length is too big for an array");
        ByteSourcePayload returnVal = new ByteSourcePayload(ByteSource.wrap(content).slice(offset, length));
        return returnVal;
    }

    protected Payload copyMetadataAndSetLength(Payload input, Payload returnVal, long length) {
        returnVal.setContentMetadata(BaseMutableContentMetadata.fromContentMetadata(input.getContentMetadata().toBuilder().contentLength(length).contentMD5((HashCode)null).build()));
        return returnVal;
    }

    @Override
    public Iterable<Payload> slice(Payload input, long size) {
        Preconditions.checkNotNull(input, "input");
        Preconditions.checkArgument(size >= 0L, "size must be non-negative but was: %s", size);
        ContentMetadata meta = BaseMutableContentMetadata.fromContentMetadata(input.getContentMetadata()).toBuilder().contentLength(size).contentMD5((HashCode)null).build();
        Object rawContent = input.getRawContent();
        if (rawContent instanceof File) {
            return this.doSlice((File)rawContent, meta);
        }
        if (rawContent instanceof String) {
            return this.doSlice((String)rawContent, meta);
        }
        if (rawContent instanceof byte[]) {
            return this.doSlice((byte[])rawContent, meta);
        }
        if (rawContent instanceof InputStream) {
            return this.doSlice((InputStream)rawContent, meta);
        }
        return this.doSlice(input, meta);
    }

    protected Iterable<Payload> doSlice(Payload input, ContentMetadata meta) {
        return this.doSlice(input.getInput(), meta);
    }

    protected Iterable<Payload> doSlice(String rawContent, ContentMetadata meta) {
        return this.doSlice(rawContent.getBytes(Charsets.UTF_8), meta);
    }

    protected Iterable<Payload> doSlice(byte[] rawContent, ContentMetadata meta) {
        return this.doSlice(new ByteArrayInputStream(rawContent), meta);
    }

    protected Iterable<Payload> doSlice(File rawContent, ContentMetadata meta) {
        try {
            return this.doSlice(new FileInputStream(rawContent), meta);
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate(e);
        }
    }

    protected Iterable<Payload> doSlice(InputStream rawContent, ContentMetadata meta) {
        return new PayloadIterator(rawContent, meta);
    }

    public static class PayloadIterator
    implements Iterable<Payload>,
    Iterator<Payload> {
        private final InputStream input;
        private final ContentMetadata metaData;
        private Payload nextPayload;
        private final int readLen;

        public PayloadIterator(InputStream input, ContentMetadata meta) {
            this.input = Preconditions.checkNotNull(input, "input");
            this.metaData = Preconditions.checkNotNull(meta, "meta");
            this.readLen = Preconditions.checkNotNull(this.metaData.getContentLength(), "content-length").intValue();
            this.nextPayload = this.getNextPayload();
        }

        @Override
        public boolean hasNext() {
            return this.nextPayload != null;
        }

        @Override
        public Payload next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Payload payload = this.nextPayload;
            this.nextPayload = this.getNextPayload();
            return payload;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Payload> iterator() {
            return this;
        }

        private Payload getNextPayload() {
            byte[] content = new byte[this.readLen];
            int offset = 0;
            try {
                while (true) {
                    int read;
                    if ((read = this.input.read(content, offset, this.readLen - offset)) <= 0) {
                        if (offset == 0) {
                            return null;
                        }
                        break;
                    }
                    offset += read;
                }
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            return this.createPayload(content.length == offset ? content : Arrays.copyOf(content, offset));
        }

        private Payload createPayload(byte[] content) {
            ByteArrayPayload payload = null;
            if (content.length > 0) {
                payload = new ByteArrayPayload(content);
                ContentMetadata cm = this.metaData.toBuilder().contentLength(Long.valueOf(content.length)).contentMD5((HashCode)null).build();
                payload.setContentMetadata(BaseMutableContentMetadata.fromContentMetadata(cm));
            }
            return payload;
        }
    }
}

