/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.jclouds.crypto.Crypto;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.DelegatingPayload;

public abstract class BaseCipherPayload
extends DelegatingPayload {
    private final Key key;
    protected final Crypto crypto;

    public BaseCipherPayload(Crypto crypto, Payload delegate, Key key) {
        super(delegate);
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
        this.key = Preconditions.checkNotNull(key, "key");
    }

    public abstract Cipher initializeCipher(Key var1);

    @Override
    public CipherInputStream openStream() throws IOException {
        return new CipherInputStream(super.openStream(), this.initializeCipher(this.key));
    }
}

