/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0;

import com.google.common.base.Optional;
import java.io.Closeable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.extensions.RoleAdminApi;
import org.jclouds.openstack.keystone.v2_0.extensions.ServiceAdminApi;
import org.jclouds.openstack.keystone.v2_0.extensions.TenantAdminApi;
import org.jclouds.openstack.keystone.v2_0.extensions.UserAdminApi;
import org.jclouds.openstack.keystone.v2_0.features.ServiceApi;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.keystone.v2_0.features.TokenApi;
import org.jclouds.openstack.keystone.v2_0.features.UserApi;
import org.jclouds.openstack.v2_0.features.ExtensionApi;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.SelectJson;

public interface KeystoneApi
extends Closeable {
    @Named(value="keystone:getApiMetadata")
    @GET
    @SelectJson(value={"version"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ApiMetadata getApiMetadata();

    @Delegate
    public ServiceApi getServiceApi();

    @Delegate
    public ExtensionApi getExtensionApi();

    @Delegate
    public Optional<? extends TokenApi> getTokenApi();

    @Delegate
    public Optional<? extends UserApi> getUserApi();

    @Delegate
    public Optional<? extends TenantApi> getTenantApi();

    @Delegate
    public Optional<? extends UserAdminApi> getUserAdminApi();

    @Delegate
    public Optional<? extends TenantAdminApi> getTenantAdminApi();

    @Delegate
    public Optional<? extends RoleAdminApi> getRoleAdminApi();

    @Delegate
    public Optional<? extends ServiceAdminApi> getServiceAdminApi();
}

