/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindAuthToJsonPayload
extends BindToJsonPayload
implements MapBinder {
    @Inject
    public BindAuthToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("BindAuthToJsonPayload needs parameters");
    }

    protected void addCredentialsInArgsOrNull(GeneratedHttpRequest gRequest, ImmutableMap.Builder<String, Object> builder) {
        for (Object arg : Iterables.filter(gRequest.getInvocation().getArgs(), Predicates.notNull())) {
            if (!arg.getClass().isAnnotationPresent(CredentialType.class)) continue;
            builder.put(arg.getClass().getAnnotation(CredentialType.class).value(), arg);
        }
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        this.addCredentialsInArgsOrNull(gRequest, builder);
        if (!Strings.isNullOrEmpty((String)postParams.get("tenantName"))) {
            builder.put("tenantName", postParams.get("tenantName"));
        } else if (!Strings.isNullOrEmpty((String)postParams.get("tenantId"))) {
            builder.put("tenantId", postParams.get("tenantId"));
        }
        return super.bindToRequest(request, ImmutableMap.of("auth", builder.build()));
    }
}

