/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import java.io.IOException;
import java.util.Set;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.internal.NullFilteringTypeAdapterFactories;

public class KeystoneParserModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind(NullFilteringTypeAdapterFactories.SetTypeAdapterFactory.class).to(ValuesSetTypeAdapterFactory.class);
    }

    public static class ValuesSetTypeAdapterFactory
    extends NullFilteringTypeAdapterFactories.SetTypeAdapterFactory {
        @Override
        protected <E, I> TypeAdapter<I> newAdapter(TypeAdapter<E> elementAdapter) {
            return new Adapter<E>(elementAdapter);
        }

        public static final class Adapter<E>
        extends TypeAdapter<Set<E>> {
            private final NullFilteringTypeAdapterFactories.SetTypeAdapter<E> delegate;

            public Adapter(TypeAdapter<E> elementAdapter) {
                this.delegate = new NullFilteringTypeAdapterFactories.SetTypeAdapter<E>(elementAdapter);
                this.nullSafe();
            }

            @Override
            public void write(JsonWriter out, Set<E> value) throws IOException {
                this.delegate.write(out, value);
            }

            @Override
            public Set<E> read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.BEGIN_OBJECT) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    boolean foundValues = false;
                    in.beginObject();
                    while (in.hasNext()) {
                        String name = in.nextName();
                        if (Objects.equal("values", name)) {
                            foundValues = true;
                            builder.addAll((Iterable)this.delegate.read(in));
                            continue;
                        }
                        in.skipValue();
                    }
                    Preconditions.checkState(foundValues, "Expected BEGIN_ARRAY or the object to contain an array called 'values'");
                    in.endObject();
                    return builder.build();
                }
                return this.delegate.read(in);
            }
        }
    }
}

