/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;

@Singleton
public class NovaSecurityGroupInZoneToSecurityGroup
implements Function<SecurityGroupInZone, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroup> baseConverter;
    protected final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public NovaSecurityGroupInZoneToSecurityGroup(Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroup> baseConverter, Supplier<Map<String, Location>> locationIndex) {
        this.baseConverter = Preconditions.checkNotNull(baseConverter, "baseConverter");
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
    }

    @Override
    public SecurityGroup apply(SecurityGroupInZone group) {
        SecurityGroupBuilder builder = SecurityGroupBuilder.fromSecurityGroup(this.baseConverter.apply(group.getSecurityGroup()));
        Location zone = this.locationIndex.get().get(group.getZone());
        Preconditions.checkState(zone != null, "location %s not in locationIndex: %s", group.getZone(), this.locationIndex.get());
        builder.location(zone);
        builder.id(group.getZone() + "/" + group.getSecurityGroup().getId());
        return builder.build();
    }
}

