/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Atomics;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;

public class SecurityGroupRuleToIpPermission
implements Function<SecurityGroupRule, IpPermission> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Predicate<AtomicReference<ZoneAndName>> returnSecurityGroupExistsInZone;
    protected final Supplier<Map<String, Location>> locationIndex;
    LoadingCache<ZoneAndName, SecurityGroupInZone> groupMap;

    @Inject
    public SecurityGroupRuleToIpPermission(@Named(value="SECURITYGROUP_PRESENT") Predicate<AtomicReference<ZoneAndName>> returnSecurityGroupExistsInZone, Supplier<Map<String, Location>> locationIndex, LoadingCache<ZoneAndName, SecurityGroupInZone> groupMap) {
        this.returnSecurityGroupExistsInZone = Preconditions.checkNotNull(returnSecurityGroupExistsInZone, "returnSecurityGroupExistsInZone");
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
        this.groupMap = Preconditions.checkNotNull(groupMap, "groupMap");
    }

    @Override
    public IpPermission apply(SecurityGroupRule rule) {
        String zone;
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(rule.getIpProtocol());
        builder.fromPort(rule.getFromPort());
        builder.toPort(rule.getToPort());
        if (rule.getGroup() != null && (zone = (String)Iterables.getFirst(Iterables.filter(this.locationIndex.get().keySet(), this.isSecurityGroupInZone(rule.getGroup().getName())), null)) != null) {
            SecurityGroupInZone group = this.groupMap.getUnchecked(ZoneAndName.fromZoneAndName(zone, rule.getGroup().getName()));
            builder.groupId(zone + "/" + group.getSecurityGroup().getId());
        }
        if (rule.getIpRange() != null) {
            builder.cidrBlock(rule.getIpRange());
        }
        return builder.build();
    }

    protected Predicate<String> isSecurityGroupInZone(final String groupName) {
        return new Predicate<String>(){

            @Override
            public boolean apply(String zone) {
                AtomicReference<ZoneAndName> securityGroupInZoneRef = Atomics.newReference(ZoneAndName.fromZoneAndName(zone, groupName));
                return SecurityGroupRuleToIpPermission.this.returnSecurityGroupExistsInZone.apply(securityGroupInZoneRef);
            }
        };
    }
}

