/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.util.InetAddresses2;

public class ServerInZoneToNodeMetadata
implements Function<ServerInZone, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus;
    protected final Supplier<Map<String, Location>> locationIndex;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;
    private static final Predicate<Address> isPrivateAddress = new Predicate<Address>(){

        @Override
        public boolean apply(Address in) {
            return InetAddresses2.IsPrivateIPAddress.INSTANCE.apply(in.getAddr());
        }
    };
    public static final Predicate<String> isInet4Address = new Predicate<String>(){

        @Override
        public boolean apply(String input) {
            try {
                return InetAddresses.forString(input) instanceof Inet4Address;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
    };

    @Inject
    public ServerInZoneToNodeMetadata(Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus, Supplier<Map<String, Location>> locationIndex, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.toPortableNodeStatus = Preconditions.checkNotNull(toPortableNodeStatus, "toPortableNodeStatus");
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.locationIndex = Preconditions.checkNotNull(locationIndex, "locationIndex");
        this.images = Preconditions.checkNotNull(images, "images");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares");
    }

    @Override
    public NodeMetadata apply(ServerInZone serverInZone) {
        Location zone = this.locationIndex.get().get(serverInZone.getZone());
        Preconditions.checkState(zone != null, "location %s not in locationIndex: %s", serverInZone.getZone(), this.locationIndex.get());
        Server from = serverInZone.getServer();
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.id(serverInZone.slashEncode());
        builder.providerId(from.getId());
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(from.getHostId() != null ? new LocationBuilder().scope(LocationScope.HOST).id(from.getHostId()).description(from.getHostId()).parent(zone).build() : zone);
        builder.group(ComputeServiceUtils.groupFromMapOrName(from.getMetadata(), from.getName(), this.nodeNamingConvention));
        ComputeServiceUtils.addMetadataAndParseTagsFromCommaDelimitedValue(builder, from.getMetadata());
        if (from.getImage() != null) {
            builder.imageId(ZoneAndId.fromZoneAndId(serverInZone.getZone(), from.getImage().getId()).slashEncode());
        }
        builder.operatingSystem(this.findOperatingSystemForServerOrNull(serverInZone));
        builder.hardware(this.findHardwareForServerOrNull(serverInZone));
        builder.status(this.toPortableNodeStatus.get((Object)from.getStatus()));
        HashSet<Address> addresses = Sets.newHashSet(from.getAddresses().values());
        if (from.getAccessIPv4() != null) {
            addresses.add(Address.createV4(from.getAccessIPv4()));
        }
        if (from.getAccessIPv6() != null) {
            addresses.add(Address.createV6(from.getAccessIPv6()));
        }
        builder.publicAddresses(Iterables.filter(Iterables.transform(Iterables.filter(addresses, Predicates.not(isPrivateAddress)), AddressToStringTransformationFunction.INSTANCE), isInet4Address));
        builder.privateAddresses(Iterables.filter(Iterables.transform(Iterables.filter(addresses, isPrivateAddress), AddressToStringTransformationFunction.INSTANCE), isInet4Address));
        for (Link link : from.getLinks()) {
            if (!link.getRelation().equals((Object)Link.Relation.SELF)) continue;
            builder.uri(link.getHref());
        }
        return builder.build();
    }

    protected Hardware findHardwareForServerOrNull(ServerInZone serverInZone) {
        return this.findObjectOfTypeForServerOrNull(this.hardwares.get(), "hardware", serverInZone.getServer().getFlavor().getId(), serverInZone);
    }

    protected OperatingSystem findOperatingSystemForServerOrNull(ServerInZone serverInZone) {
        if (serverInZone.getServer().getImage() != null) {
            Image image = this.findObjectOfTypeForServerOrNull(this.images.get(), "image", serverInZone.getServer().getImage().getId(), serverInZone);
            return image != null ? image.getOperatingSystem() : null;
        }
        return null;
    }

    public <T extends ComputeMetadata> T findObjectOfTypeForServerOrNull(Set<? extends T> supply, String type, final String objectId, final ZoneAndId serverInZone) {
        try {
            return (T)((ComputeMetadata)Iterables.find(supply, new Predicate<T>(){

                @Override
                public boolean apply(T input) {
                    return input.getId().equals(ZoneAndId.fromZoneAndId(serverInZone.getZone(), objectId).slashEncode());
                }
            }));
        }
        catch (NoSuchElementException e) {
            this.logger.trace("could not find %s with id(%s) for server(%s)", type, objectId, serverInZone);
            return null;
        }
    }

    private static enum AddressToStringTransformationFunction implements Function<Address, String>
    {
        INSTANCE;


        @Override
        public String apply(Address address) {
            return address.getAddr();
        }
    }
}

