/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.config;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.HostResourceUsage;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedAttributes;
import org.jclouds.openstack.nova.v2_0.domain.ServerExtendedStatus;
import org.jclouds.openstack.nova.v2_0.domain.ServerWithSecurityGroups;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class NovaParserModule
extends AbstractModule {
    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings() {
        return ImmutableMap.of(HostResourceUsage.class, new HostResourceUsageAdapter(), ServerWithSecurityGroups.class, new ServerWithSecurityGroupsAdapter(), Server.class, new ServerAdapter());
    }

    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Singleton
    public static class ServerAdapter
    implements JsonDeserializer<Server> {
        @Override
        public Server deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            ServerExtendedAttributes extraAttributes;
            Server serverBase = jsonElement.getAsJsonObject().get("image").isJsonObject() ? this.apply((ServerInternal)context.deserialize(jsonElement, (Type)((Object)ServerInternal.class))) : this.apply((ServerInternalWithoutImage)context.deserialize(jsonElement, (Type)((Object)ServerInternalWithoutImage.class)));
            Object result = Server.builder().fromServer(serverBase);
            ServerExtendedStatus extendedStatus = (ServerExtendedStatus)context.deserialize(jsonElement, (Type)((Object)ServerExtendedStatus.class));
            if (!Objects.equal(extendedStatus, ServerExtendedStatus.builder().build())) {
                ((Server.Builder)result).extendedStatus(extendedStatus);
            }
            if (!Objects.equal(extraAttributes = (ServerExtendedAttributes)context.deserialize(jsonElement, (Type)((Object)ServerExtendedAttributes.class)), ServerExtendedAttributes.builder().build())) {
                ((Server.Builder)result).extendedAttributes(extraAttributes);
            }
            return ((Server.Builder)result).build();
        }

        public Server apply(Server in) {
            return ((Server.Builder)in.toBuilder()).build();
        }

        private static class ServerInternalWithoutImage
        extends Server {
            @ConstructorProperties(value={"id", "name", "links", "uuid", "tenant_id", "user_id", "updated", "created", "hostId", "accessIPv4", "accessIPv6", "status", "flavor", "key_name", "config_drive", "addresses", "metadata", "extendedStatus", "extendedAttributes", "OS-DCF:diskConfig"})
            protected ServerInternalWithoutImage(String id, @Nullable String name, Set<Link> links, @Nullable String uuid, String tenantId, String userId, Date updated, Date created, @Nullable String hostId, @Nullable String accessIPv4, @Nullable String accessIPv6, Server.Status status, Resource flavor, @Nullable String keyName, @Nullable String configDrive, Multimap<String, Address> addresses, Map<String, String> metadata, @Nullable ServerExtendedStatus extendedStatus, @Nullable ServerExtendedAttributes extendedAttributes, @Nullable String diskConfig) {
                super(id, name, links, uuid, tenantId, userId, updated, created, hostId, accessIPv4, accessIPv6, status, null, flavor, keyName, configDrive, addresses, metadata, extendedStatus, extendedAttributes, diskConfig);
            }
        }

        private static class ServerInternal
        extends Server {
            @ConstructorProperties(value={"id", "name", "links", "uuid", "tenant_id", "user_id", "updated", "created", "hostId", "accessIPv4", "accessIPv6", "status", "image", "flavor", "key_name", "config_drive", "addresses", "metadata", "extendedStatus", "extendedAttributes", "OS-DCF:diskConfig"})
            protected ServerInternal(String id, @Nullable String name, Set<Link> links, @Nullable String uuid, String tenantId, String userId, Date updated, Date created, @Nullable String hostId, @Nullable String accessIPv4, @Nullable String accessIPv6, Server.Status status, Resource image, Resource flavor, @Nullable String keyName, @Nullable String configDrive, Multimap<String, Address> addresses, Map<String, String> metadata, @Nullable ServerExtendedStatus extendedStatus, @Nullable ServerExtendedAttributes extendedAttributes, @Nullable String diskConfig) {
                super(id, name, links, uuid, tenantId, userId, updated, created, hostId, accessIPv4, accessIPv6, status, image, flavor, keyName, configDrive, addresses, metadata, extendedStatus, extendedAttributes, diskConfig);
            }
        }
    }

    @Singleton
    public static class ServerWithSecurityGroupsAdapter
    implements JsonDeserializer<ServerWithSecurityGroups> {
        @Override
        public ServerWithSecurityGroups deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            Server server = (Server)context.deserialize(jsonElement, (Type)((Object)Server.class));
            ServerWithSecurityGroups.Builder result = (ServerWithSecurityGroups.Builder)ServerWithSecurityGroups.builder().fromServer(server);
            LinkedHashSet<String> names = Sets.newLinkedHashSet();
            if (jsonElement.getAsJsonObject().get("security_groups") != null) {
                JsonArray x = jsonElement.getAsJsonObject().get("security_groups").getAsJsonArray();
                for (JsonElement y : x) {
                    names.add(y.getAsJsonObject().get("name").getAsString());
                }
                result.securityGroupNames(names);
            }
            return result.build();
        }
    }

    @Singleton
    public static class HostResourceUsageAdapter
    implements JsonSerializer<HostResourceUsage>,
    JsonDeserializer<HostResourceUsage> {
        public HostResourceUsage apply(HostResourceUsageView in) {
            return in.resource.toBuilder().build();
        }

        @Override
        public HostResourceUsage deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            return this.apply((HostResourceUsageView)context.deserialize(jsonElement, (Type)((Object)HostResourceUsageView.class)));
        }

        @Override
        public JsonElement serialize(HostResourceUsage hostResourceUsage, Type type, JsonSerializationContext context) {
            return context.serialize(hostResourceUsage);
        }

        private static class HostResourceUsageInternal
        extends HostResourceUsage {
            @ConstructorProperties(value={"host", "project", "memory_mb", "cpu", "disk_gb"})
            protected HostResourceUsageInternal(String host, @Nullable String project, int memoryMb, int cpu, int diskGb) {
                super(host, project, memoryMb, cpu, diskGb);
            }
        }

        private static class HostResourceUsageView {
            protected HostResourceUsageInternal resource;

            private HostResourceUsageView() {
            }
        }
    }
}

