/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Network
implements Comparable<Network> {
    private final String networkUuid;
    private final String portUuid;
    private final String fixedIp;

    @ConstructorProperties(value={"networkUuid", "portUuid", "fixedIp"})
    protected Network(String networkUuid, String portUuid, String fixedIp) {
        Preconditions.checkArgument(networkUuid != null || portUuid != null, "At least one of networkUuid or portUuid should be specified");
        this.networkUuid = networkUuid;
        this.portUuid = portUuid;
        this.fixedIp = fixedIp;
    }

    public String getNetworkUuid() {
        return this.networkUuid;
    }

    public String getPortUuid() {
        return this.portUuid;
    }

    public String getFixedIp() {
        return this.fixedIp;
    }

    public int hashCode() {
        return Objects.hashCode(this.networkUuid, this.portUuid, this.fixedIp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Network that = (Network)Network.class.cast(obj);
        return Objects.equal(this.networkUuid, that.networkUuid) && Objects.equal(this.portUuid, that.portUuid) && Objects.equal(this.fixedIp, that.fixedIp);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("networkUuid", this.networkUuid).add("portUuid", this.portUuid).add("fixedIp", this.fixedIp);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromNetwork(this);
    }

    @Override
    public int compareTo(Network that) {
        return this.toString().compareTo(that.toString());
    }

    public static class Builder {
        protected String networkUuid;
        protected String portUuid;
        protected String fixedIp;

        public Builder networkUuid(String networkUuid) {
            this.networkUuid = networkUuid;
            return this;
        }

        public Builder portUuid(String portUuid) {
            this.portUuid = portUuid;
            return this;
        }

        public Builder fixedIp(String fixedIp) {
            this.fixedIp = fixedIp;
            return this;
        }

        public Network build() {
            return new Network(this.networkUuid, this.portUuid, this.fixedIp);
        }

        public Builder fromNetwork(Network in) {
            return this.networkUuid(in.getNetworkUuid()).portUuid(in.getPortUuid()).fixedIp(in.getFixedIp());
        }
    }
}

