/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.zonescoped;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class ZoneAndId {
    protected final String zoneId;
    protected final String id;

    public static ZoneAndId fromSlashEncoded(String id) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(id, "id"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "id must be in format zoneId/id");
        return new ZoneAndId(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static ZoneAndId fromZoneAndId(String zoneId, String id) {
        return new ZoneAndId(zoneId, id);
    }

    private static String slashEncodeZoneAndId(String zoneId, String id) {
        return Preconditions.checkNotNull(zoneId, "zoneId") + "/" + Preconditions.checkNotNull(id, "id");
    }

    public String slashEncode() {
        return ZoneAndId.slashEncodeZoneAndId(this.zoneId, this.id);
    }

    protected ZoneAndId(String zoneId, String id) {
        this.zoneId = Preconditions.checkNotNull(zoneId, "zoneId");
        this.id = Preconditions.checkNotNull(id, "id");
    }

    public int hashCode() {
        return Objects.hashCode(this.zoneId, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZoneAndId other = (ZoneAndId)obj;
        return Objects.equal(this.zoneId, other.zoneId) && Objects.equal(this.id, other.id);
    }

    public String getZone() {
        return this.zoneId;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "[zoneId=" + this.zoneId + ", id=" + this.id + "]";
    }
}

