/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseServers
extends ParseJson<Servers> {
    @Inject
    public ParseServers(Json json) {
        super(json, TypeLiteral.get(Servers.class));
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Resource, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = Preconditions.checkNotNull(api, "api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Resource>> markerToNextForArg0(Optional<Object> arg0) {
            String zone = arg0.get().toString();
            final ServerApi serverApi = this.api.getServerApiForZone(zone);
            return new Function<Object, IterableWithMarker<Resource>>(){

                @Override
                public IterableWithMarker<Resource> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return (IterableWithMarker)IterableWithMarker.class.cast(serverApi.list(paginationOptions));
                }

                public String toString() {
                    return "list()";
                }
            };
        }
    }

    static class Servers
    extends PaginatedCollection<Resource> {
        @ConstructorProperties(value={"servers", "servers_links"})
        protected Servers(Iterable<Resource> servers, Iterable<Link> servers_links) {
            super(servers, servers_links);
        }
    }
}

