/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.jclouds.reflect.Invocation;

public class SetCaller {
    private final ThreadLocal<Invocation> caller = new ThreadLocal();
    private static final Key<Invocation> CALLER_INVOCATION = Key.get(Invocation.class, (Annotation)Names.named("caller"));

    public void enter(Invocation caller) {
        Preconditions.checkState(this.caller.get() == null, "A scoping block is already in progress");
        this.caller.set(caller);
    }

    public void exit() {
        Preconditions.checkState(this.caller.get() != null, "No scoping block in progress");
        this.caller.remove();
    }

    class CallerInvocationProvider
    implements Provider<Invocation> {
        CallerInvocationProvider() {
        }

        @Override
        public Invocation get() {
            return (Invocation)SetCaller.this.caller.get();
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        public void configure() {
            SetCaller delegateScope = new SetCaller();
            this.bind(CALLER_INVOCATION).toProvider(delegateScope.new CallerInvocationProvider());
            this.bind(SetCaller.class).toInstance(delegateScope);
        }
    }
}

