/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.functionloader.osgi;

import com.google.common.base.Strings;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.functionloader.FunctionLoader;
import org.jclouds.scriptbuilder.functionloader.FunctionNotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceFunctionLoader
implements FunctionLoader {
    private final BundleContext bundleContext;

    public ServiceFunctionLoader(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public String loadFunction(String function, OsFamily family) throws FunctionNotFoundException {
        ServiceReference[] references = null;
        String filter = String.format("(function=*%s.%s*)", function, ShellToken.SH.to(family));
        try {
            references = this.bundleContext.getServiceReferences(FunctionLoader.class.getName(), filter);
            if (references != null) {
                for (ServiceReference reference : references) {
                    FunctionLoader loader = (FunctionLoader)this.bundleContext.getService(reference);
                    String f = loader.loadFunction(function, family);
                    if (Strings.isNullOrEmpty(f)) continue;
                    String string = f;
                    return string;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            throw new FunctionNotFoundException(function, family, e);
        }
        finally {
            if (references != null) {
                for (ServiceReference reference : references) {
                    this.bundleContext.ungetService(reference);
                }
            }
        }
        throw new FunctionNotFoundException(function, family);
    }
}

