/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.ssh.AuthorizeRSAPublicKeys;
import org.jclouds.scriptbuilder.statements.ssh.InstallRSAPrivateKey;

public class UserAdd
implements Statement {
    private final Function<String, String> cryptFunction;
    private final String home;
    private final String defaultHome;
    private final String login;
    private final List<String> groups;
    private final String password;
    private final String installRSAPrivateKey;
    private final List<String> authorizeRSAPublicKeys;
    private final String shell;
    private final String fullName;

    public static Builder builder() {
        return new Builder();
    }

    public UserAdd(Function<String, String> cryptFunction, String login, List<String> groups, @Nullable String password, @Nullable String installRSAPrivateKey, List<String> authorizeRSAPublicKeys, String defaultHome, String shell) {
        this(cryptFunction, login, groups, password, installRSAPrivateKey, authorizeRSAPublicKeys, null, defaultHome, shell, login);
    }

    public UserAdd(Function<String, String> cryptFunction, String login, List<String> groups, @Nullable String password, @Nullable String installRSAPrivateKey, List<String> authorizeRSAPublicKeys, @Nullable String home, String defaultHome, String shell, String fullName) {
        this.login = Preconditions.checkNotNull(login, "login");
        this.password = password;
        this.cryptFunction = password == null ? null : Preconditions.checkNotNull(cryptFunction, "cryptFunction must be set! ex. org.jclouds.compute.functions.Sha512Crypt.INSTANCE");
        this.groups = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(groups, "groups"));
        this.installRSAPrivateKey = installRSAPrivateKey;
        this.authorizeRSAPublicKeys = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(authorizeRSAPublicKeys, "authorizeRSAPublicKeys"));
        this.home = home;
        this.defaultHome = Preconditions.checkNotNull(defaultHome, "defaultHome");
        this.shell = Preconditions.checkNotNull(shell, "shell");
        this.fullName = fullName;
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    @Override
    public String render(OsFamily family) {
        Preconditions.checkNotNull(family, "family");
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        String homeDir = this.home != null ? this.home : this.defaultHome + '/' + this.login;
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add(Statements.exec("{md} " + homeDir.substring(0, homeDir.lastIndexOf(47))));
        ImmutableMap.Builder<String, String> userAddOptions = ImmutableMap.builder();
        if (Strings.isNullOrEmpty(this.fullName)) {
            userAddOptions.put("-c", this.login);
        } else {
            userAddOptions.put("-c", "'" + this.fullName + "'");
        }
        userAddOptions.put("-s", this.shell);
        if (this.groups.size() > 0) {
            for (String group : this.groups) {
                statements.add(Statements.exec("groupadd -f " + group));
            }
            ArrayList<String> groups = Lists.newArrayList(this.groups);
            String primaryGroup = (String)groups.remove(0);
            userAddOptions.put("-g", primaryGroup);
            if (groups.size() > 0) {
                userAddOptions.put("-G", Joiner.on(',').join(groups));
            }
        }
        userAddOptions.put("-m", "");
        userAddOptions.put("-d", homeDir);
        if (this.password != null) {
            try {
                userAddOptions.put("-p", "'" + this.cryptFunction.apply(this.password) + "'");
            }
            catch (Exception e) {
                Throwables.propagate(e);
            }
        }
        String options = Joiner.on(' ').withKeyValueSeparator(" ").join(userAddOptions.build());
        statements.add(Statements.exec(String.format("useradd %s %s", options, this.login)));
        if (this.authorizeRSAPublicKeys.size() > 0 || this.installRSAPrivateKey != null) {
            String sshDir = homeDir + "{fs}.ssh";
            if (this.authorizeRSAPublicKeys.size() > 0) {
                statements.add(new AuthorizeRSAPublicKeys(sshDir, this.authorizeRSAPublicKeys));
            }
            if (this.installRSAPrivateKey != null) {
                statements.add(new InstallRSAPrivateKey(sshDir, this.installRSAPrivateKey));
            }
        }
        statements.add(Statements.exec(String.format("chown -R %s %s", this.login, homeDir)));
        return new StatementList(statements.build()).render(family);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAdd that = (UserAdd)UserAdd.class.cast(o);
        return Objects.equal(this.login, that.login);
    }

    public int hashCode() {
        return Objects.hashCode(this.login);
    }

    public String toString() {
        return Objects.toStringHelper("").add("login", this.login).toString();
    }

    public static class Builder {
        private Function<String, String> cryptFunction;
        private String defaultHome = "/home/users";
        private String home;
        private String login;
        private String password;
        private String RSAPrivateKey;
        private List<String> groups = Lists.newArrayList();
        private List<String> authorizeRSAPublicKeys = Lists.newArrayList();
        private String shell = "/bin/bash";
        private String fullName;

        public Builder cryptFunction(Function<String, String> cryptFunction) {
            this.cryptFunction = cryptFunction;
            return this;
        }

        public Builder home(String home) {
            this.home = home;
            return this;
        }

        public Builder defaultHome(String defaultHome) {
            this.defaultHome = defaultHome;
            return this;
        }

        public Builder login(String login) {
            this.login = login;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder group(String group) {
            this.groups.add(Preconditions.checkNotNull(group, "group"));
            return this;
        }

        public Builder groups(Iterable<String> groups) {
            this.groups = ImmutableList.copyOf(Preconditions.checkNotNull(groups, "groups"));
            return this;
        }

        public Builder installRSAPrivateKey(String RSAPrivateKey2) {
            this.RSAPrivateKey = RSAPrivateKey2;
            return this;
        }

        public Builder authorizeRSAPublicKey(String RSAPublicKey2) {
            this.authorizeRSAPublicKeys.add(Preconditions.checkNotNull(RSAPublicKey2, "RSAPublicKey"));
            return this;
        }

        public Builder authorizeRSAPublicKeys(Iterable<String> RSAPublicKeys) {
            this.authorizeRSAPublicKeys = ImmutableList.copyOf(Preconditions.checkNotNull(RSAPublicKeys, "RSAPublicKeys"));
            return this;
        }

        public Builder shell(String shell) {
            this.shell = shell;
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public UserAdd build() {
            return new UserAdd(this.cryptFunction, this.login, this.groups, this.password, this.RSAPrivateKey, this.authorizeRSAPublicKeys, this.home, this.defaultHome, this.shell, this.fullName);
        }
    }
}

