/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.sparkjava;

import com.elepy.exceptions.ElepyException;
import com.elepy.http.Request;
import com.elepy.http.Session;
import com.elepy.sparkjava.SparkSession;
import com.elepy.uploads.FileUpload;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import spark.QueryParamsMap;

public class SparkRequest
implements Request {
    private final spark.Request request;

    public SparkRequest(spark.Request request) {
        this.request = request;
    }

    public Map<String, String> params() {
        HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
        this.request.params().forEach((key, value) -> objectObjectHashMap.put(key.replaceAll(":", ""), (String)value));
        return objectObjectHashMap;
    }

    public String[] queryParamValues(String key) {
        return this.request.queryParamsValues(key);
    }

    public String params(String param) {
        return this.request.params(param);
    }

    public String[] splat() {
        return this.request.splat();
    }

    public String method() {
        return this.request.requestMethod();
    }

    public String scheme() {
        return this.request.scheme();
    }

    public String host() {
        return this.request.host();
    }

    public String userAgent() {
        return this.request.userAgent();
    }

    public int port() {
        return this.request.port();
    }

    public String pathInfo() {
        return this.request.pathInfo();
    }

    public String servletPath() {
        return this.request.servletPath();
    }

    public String contextPath() {
        return this.request.contextPath();
    }

    public String url() {
        return this.request.url();
    }

    public String contentType() {
        return this.request.contentType();
    }

    public String ip() {
        return this.request.ip();
    }

    public String body() {
        return this.request.body();
    }

    public byte[] bodyAsBytes() {
        return this.request.bodyAsBytes();
    }

    public int contentLength() {
        return this.request.contentLength();
    }

    public String queryParams(String queryParam) {
        return this.request.queryParams(queryParam);
    }

    public String queryParamOrDefault(String queryParam, String defaultValue) {
        return this.request.queryParamOrDefault(queryParam, defaultValue);
    }

    public String[] queryParamsValues(String queryParam) {
        return this.request.queryParamsValues(queryParam);
    }

    public String headers(String header) {
        return this.request.headers(header);
    }

    public Set<String> queryParams() {
        return this.request.queryParams();
    }

    public Set<String> headers() {
        return this.request.headers();
    }

    public String queryString() {
        return this.request.queryString();
    }

    public void attribute(String attribute, Object value) {
        this.request.attribute(attribute, value);
    }

    public <T> T attribute(String attribute) {
        return (T)this.request.attribute(attribute);
    }

    public Set<String> attributes() {
        return this.request.attributes();
    }

    public HttpServletRequest servletRequest() {
        return this.request.raw();
    }

    public QueryParamsMap queryMap() {
        return this.request.queryMap();
    }

    public QueryParamsMap queryMap(String key) {
        return this.request.queryMap(key);
    }

    public Session session() {
        return new SparkSession(this.request.session());
    }

    public Session session(boolean create) {
        return new SparkSession(this.request.session(create));
    }

    public Map<String, String> cookies() {
        return this.request.cookies();
    }

    public String cookie(String name) {
        return this.request.cookie(name);
    }

    public String uri() {
        return this.request.uri();
    }

    public String protocol() {
        return this.request.protocol();
    }

    public List<FileUpload> uploadedFiles(String key) {
        String contentType = this.headers("Content-Type");
        if (contentType != null && contentType.toLowerCase().contains("multipart/form-data")) {
            HttpServletRequest servletRequest = this.request.raw();
            servletRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
            try {
                return servletRequest.getParts().stream().filter(part -> part.getSubmittedFileName() != null && part.getName().equals(key)).map(part -> {
                    try {
                        return FileUpload.of((String)part.getSubmittedFileName(), (String)part.getContentType(), (InputStream)part.getInputStream(), (long)part.getSize());
                    }
                    catch (IOException e) {
                        throw new ElepyException("File upload failed", 500);
                    }
                }).collect(Collectors.toList());
            }
            catch (IOException | ServletException e) {
                throw new ElepyException("File upload failed", 500);
            }
        }
        return Collections.emptyList();
    }
}

