/*
 * Decompiled with CFR 0.152.
 */
package com.elepy.sparkjava;

import com.elepy.auth.UserPermissionFilter;
import com.elepy.http.ExceptionHandler;
import com.elepy.http.HttpContext;
import com.elepy.http.HttpContextHandler;
import com.elepy.http.HttpService;
import com.elepy.http.StaticFileLocation;
import com.elepy.sparkjava.SparkContext;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Route;
import spark.RouteImpl;
import spark.Service;
import spark.route.HttpMethod;

public class SparkService
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(SparkService.class);
    private final Service http = Service.ignite();
    private Map<RouteKey, com.elepy.http.Route> routes = new TreeMap<RouteKey, com.elepy.http.Route>();
    private int counter;
    private boolean ignitedOnce = false;

    public void port(int port) {
        this.http.port(port);
    }

    public int port() {
        return this.http.port();
    }

    public void notFound(Route route) {
        this.http.notFound(route);
    }

    public void internalServerError(Route route) {
        this.http.internalServerError(route);
    }

    public void stop() {
        this.http.stop();
        this.http.awaitStop();
    }

    public void staticFiles(String path, StaticFileLocation location) {
        if (location.equals((Object)StaticFileLocation.EXTERNAL)) {
            this.http.staticFiles.externalLocation(path);
        } else {
            this.http.staticFiles.location(path);
        }
    }

    public <T extends Exception> void exception(Class<T> exceptionClass, ExceptionHandler<? super T> handler) {
        this.http.exception(exceptionClass, (e, req, res) -> handler.handleException(e, (HttpContext)new SparkContext(req, res)));
    }

    public void addRoute(com.elepy.http.Route route) {
        this.routes.put(new RouteKey(this.counter++), route);
        if (this.ignitedOnce) {
            this.ignite();
        }
    }

    public void ignite() {
        this.routes.forEach((key, route) -> {
            if (!key.ignited) {
                key.ignited = true;
                this.igniteRoute((com.elepy.http.Route)route);
            }
        });
        this.ignitedOnce = true;
        this.http.awaitInitialization();
    }

    public void before(String path, HttpContextHandler contextHandler) {
        this.http.before(path, (request, response) -> contextHandler.handle((HttpContext)new SparkContext(request, response)));
    }

    public void before(HttpContextHandler contextHandler) {
        this.http.before((request, response) -> contextHandler.handle((HttpContext)new SparkContext(request, response)));
    }

    public void after(String path, HttpContextHandler contextHandler) {
        this.http.before(path, (request, response) -> contextHandler.handle((HttpContext)new SparkContext(request, response)));
    }

    public void after(HttpContextHandler contextHandler) {
        this.http.before((request, response) -> contextHandler.handle((HttpContext)new SparkContext(request, response)));
    }

    public void afterAfter(Filter filter) {
        this.http.afterAfter(filter);
    }

    private void igniteRoute(com.elepy.http.Route extraRoute) {
        logger.debug(String.format("Ignited Route: [%s] %s", extraRoute.getMethod().name(), extraRoute.getPath()));
        this.http.addRoute(HttpMethod.get((String)extraRoute.getMethod().name().toLowerCase()), RouteImpl.create((String)extraRoute.getPath(), (String)extraRoute.getAcceptType(), (request, response) -> {
            SparkContext sparkContext = new SparkContext(request, response);
            if (!extraRoute.getPermissions().isEmpty()) {
                sparkContext.requirePermissions(extraRoute.getPermissions());
                new UserPermissionFilter((Collection)extraRoute.getPermissions()).authenticate((HttpContext)sparkContext);
            }
            extraRoute.getHttpContextHandler().handle((HttpContext)sparkContext);
            return response.body();
        }));
    }

    private class RouteKey
    implements Comparable<RouteKey> {
        private final Integer id;
        private boolean ignited;

        private RouteKey(Integer id) {
            this.id = id;
            this.ignited = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteKey routeKey = (RouteKey)o;
            return Objects.equals(this.id, routeKey.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        @Override
        public int compareTo(RouteKey o) {
            return this.id.compareTo(o.id);
        }
    }
}

