/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.json.deserializer;

import com.eligible.model.coverage.Date;
import com.eligible.model.coverage.Dates;
import com.eligible.net.APIResource;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class DatesDeserializer
implements JsonDeserializer<Dates> {
    private static final Type DATE_LIST_TYPE = new TypeToken<List<Date>>(){}.getType();

    public Dates deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = APIResource.GSON;
        if (json.isJsonArray()) {
            Dates collection = new Dates();
            collection.setData(new ArrayList());
            JsonArray jsonDates = json.getAsJsonArray();
            for (JsonElement jsonDate : jsonDates) {
                if (jsonDate.isJsonArray()) {
                    List dates = (List)gson.fromJson(jsonDate, DATE_LIST_TYPE);
                    collection.addAll(dates);
                    continue;
                }
                Date date = (Date)gson.fromJson(jsonDate, Date.class);
                collection.add(date);
            }
            return collection;
        }
        throw new IllegalArgumentException("Can not deserialize class Dates. Expected an array but got: " + json);
    }
}

