/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.json.deserializer;

import com.eligible.model.coverage.FinancialFlow;
import com.eligible.net.APIResource;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class FinancialFlowListDeserializer
implements JsonDeserializer<List<FinancialFlow>> {
    private static final Type DATE_LIST_TYPE = new TypeToken<List<FinancialFlow>>(){}.getType();

    public List<FinancialFlow> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = APIResource.GSON;
        ArrayList<FinancialFlow> collection = new ArrayList<FinancialFlow>();
        JsonArray jsonFinancialFlows = json.getAsJsonArray();
        for (JsonElement jsonFinancialFlow : jsonFinancialFlows) {
            if (jsonFinancialFlow.isJsonArray()) {
                List dates = (List)gson.fromJson(jsonFinancialFlow, DATE_LIST_TYPE);
                collection.addAll(dates);
                continue;
            }
            FinancialFlow date = (FinancialFlow)gson.fromJson(jsonFinancialFlow, FinancialFlow.class);
            collection.add(date);
        }
        return collection;
    }
}

