/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.model;

import com.eligible.exception.APIConnectionException;
import com.eligible.exception.APIException;
import com.eligible.exception.AuthenticationException;
import com.eligible.exception.InvalidRequestException;
import com.eligible.model.claim.Acknowledgement;
import com.eligible.model.claim.Financials;
import com.eligible.model.claim.Patient;
import com.eligible.model.claim.Payee;
import com.eligible.model.claim.Payer;
import com.eligible.model.claim.Provider;
import com.eligible.net.APIResource;
import com.eligible.net.RequestMethod;
import com.eligible.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Claim
extends APIResource {
    String success;
    String createdAt;
    String referenceId;

    public static Claim create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Claim.create(params, null);
    }

    public static Acknowledgements getAcknowledgements(String referenceId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Claim.getAcknowledgements(referenceId, null);
    }

    public static Acknowledgements queryAcknowledgements(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Claim.queryAcknowledgements(params, null);
    }

    public static PaymentReport getPaymentReport(String referenceId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Claim.getPaymentReport(referenceId, (RequestOptions)null);
    }

    public static PaymentReport getPaymentReport(String referenceId, String paymentReportId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Claim.getPaymentReport(referenceId, paymentReportId, null);
    }

    public static PaymentReports queryPaymentReports(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Claim.queryPaymentReports(params, null);
    }

    public static Claim create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Claim.request(RequestMethod.POST, Claim.classURL(Claim.class), params, Claim.class, options);
    }

    public static Acknowledgements getAcknowledgements(String referenceId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Acknowledgements.retrieve(referenceId, options);
    }

    public static Acknowledgements queryAcknowledgements(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Acknowledgements.query(params, options);
    }

    public static PaymentReport getPaymentReport(String referenceId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return PaymentReport.retrieve(referenceId, options);
    }

    public static PaymentReport getPaymentReport(String claimReferenceId, String paymentReportId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return PaymentReport.retrieve(claimReferenceId, paymentReportId, options);
    }

    public static PaymentReports queryPaymentReports(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return PaymentReports.query(params, options);
    }

    public String getId() {
        return this.getReferenceId();
    }

    public String getSuccess() {
        return this.success;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Claim)) {
            return false;
        }
        Claim other = (Claim)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$success = this.getSuccess();
        String other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !this$success.equals(other$success)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        return !(this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Claim;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : $success.hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        return result;
    }

    public static class PaymentReports
    extends APIResource {
        List<PaymentReport> reports;
        Integer page;
        Integer perPage;
        Integer numOfPages;
        Integer total;

        public static PaymentReports query(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return PaymentReports.query(params, null);
        }

        public static PaymentReports query(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            String url = String.format("%s/%s", PaymentReports.classURL(Claim.class), PaymentReports.className(PaymentReports.class));
            return PaymentReports.request(RequestMethod.GET, url, params, PaymentReports.class, options);
        }

        public String getId() {
            return String.valueOf(this.getPage());
        }

        public List<PaymentReport> getReports() {
            return this.reports;
        }

        public Integer getPage() {
            return this.page;
        }

        public Integer getPerPage() {
            return this.perPage;
        }

        public Integer getNumOfPages() {
            return this.numOfPages;
        }

        public Integer getTotal() {
            return this.total;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentReports)) {
                return false;
            }
            PaymentReports other = (PaymentReports)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PaymentReport> this$reports = this.getReports();
            List<PaymentReport> other$reports = other.getReports();
            if (this$reports == null ? other$reports != null : !((Object)this$reports).equals(other$reports)) {
                return false;
            }
            Integer this$page = this.getPage();
            Integer other$page = other.getPage();
            if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
                return false;
            }
            Integer this$perPage = this.getPerPage();
            Integer other$perPage = other.getPerPage();
            if (this$perPage == null ? other$perPage != null : !((Object)this$perPage).equals(other$perPage)) {
                return false;
            }
            Integer this$numOfPages = this.getNumOfPages();
            Integer other$numOfPages = other.getNumOfPages();
            if (this$numOfPages == null ? other$numOfPages != null : !((Object)this$numOfPages).equals(other$numOfPages)) {
                return false;
            }
            Integer this$total = this.getTotal();
            Integer other$total = other.getTotal();
            return !(this$total == null ? other$total != null : !((Object)this$total).equals(other$total));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PaymentReports;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PaymentReport> $reports = this.getReports();
            result = result * 59 + ($reports == null ? 43 : ((Object)$reports).hashCode());
            Integer $page = this.getPage();
            result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
            Integer $perPage = this.getPerPage();
            result = result * 59 + ($perPage == null ? 43 : ((Object)$perPage).hashCode());
            Integer $numOfPages = this.getNumOfPages();
            result = result * 59 + ($numOfPages == null ? 43 : ((Object)$numOfPages).hashCode());
            Integer $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            return result;
        }
    }

    public static class PaymentReport
    extends APIResource {
        String referenceId;
        String effectiveDate;
        Payer payer;
        Financials financials;
        Payee payee;
        Patient patient;
        Patient correctedPatient;
        Patient otherPatient;
        Provider serviceProvider;
        com.eligible.model.claim.Claim claim;

        public static PaymentReport retrieve(String referenceId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return PaymentReport.retrieve(referenceId, (RequestOptions)null);
        }

        public static PaymentReport retrieve(String claimReferenceId, String paymentReportId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return PaymentReport.retrieve(claimReferenceId, paymentReportId, null);
        }

        public static PaymentReport retrieve(String referenceId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            String url = String.format("%s/%ss", PaymentReport.instanceURL(Claim.class, referenceId), PaymentReport.className(PaymentReport.class));
            return PaymentReport.request(RequestMethod.GET, url, null, PaymentReport.class, options);
        }

        public static PaymentReport retrieve(String referenceId, String paymentReportId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            String url = String.format("%s/%ss/%s", PaymentReport.instanceURL(Claim.class, referenceId), PaymentReport.className(PaymentReport.class), paymentReportId);
            return PaymentReport.request(RequestMethod.GET, url, null, PaymentReport.class, options);
        }

        public String getId() {
            return this.getReferenceId();
        }

        public String getReferenceId() {
            return this.referenceId;
        }

        public String getEffectiveDate() {
            return this.effectiveDate;
        }

        public Payer getPayer() {
            return this.payer;
        }

        public Financials getFinancials() {
            return this.financials;
        }

        public Payee getPayee() {
            return this.payee;
        }

        public Patient getPatient() {
            return this.patient;
        }

        public Patient getCorrectedPatient() {
            return this.correctedPatient;
        }

        public Patient getOtherPatient() {
            return this.otherPatient;
        }

        public Provider getServiceProvider() {
            return this.serviceProvider;
        }

        public com.eligible.model.claim.Claim getClaim() {
            return this.claim;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentReport)) {
                return false;
            }
            PaymentReport other = (PaymentReport)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$referenceId = this.getReferenceId();
            String other$referenceId = other.getReferenceId();
            if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
                return false;
            }
            String this$effectiveDate = this.getEffectiveDate();
            String other$effectiveDate = other.getEffectiveDate();
            if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) {
                return false;
            }
            Payer this$payer = this.getPayer();
            Payer other$payer = other.getPayer();
            if (this$payer == null ? other$payer != null : !((Object)this$payer).equals(other$payer)) {
                return false;
            }
            Financials this$financials = this.getFinancials();
            Financials other$financials = other.getFinancials();
            if (this$financials == null ? other$financials != null : !((Object)this$financials).equals(other$financials)) {
                return false;
            }
            Payee this$payee = this.getPayee();
            Payee other$payee = other.getPayee();
            if (this$payee == null ? other$payee != null : !((Object)this$payee).equals(other$payee)) {
                return false;
            }
            Patient this$patient = this.getPatient();
            Patient other$patient = other.getPatient();
            if (this$patient == null ? other$patient != null : !((Object)this$patient).equals(other$patient)) {
                return false;
            }
            Patient this$correctedPatient = this.getCorrectedPatient();
            Patient other$correctedPatient = other.getCorrectedPatient();
            if (this$correctedPatient == null ? other$correctedPatient != null : !((Object)this$correctedPatient).equals(other$correctedPatient)) {
                return false;
            }
            Patient this$otherPatient = this.getOtherPatient();
            Patient other$otherPatient = other.getOtherPatient();
            if (this$otherPatient == null ? other$otherPatient != null : !((Object)this$otherPatient).equals(other$otherPatient)) {
                return false;
            }
            Provider this$serviceProvider = this.getServiceProvider();
            Provider other$serviceProvider = other.getServiceProvider();
            if (this$serviceProvider == null ? other$serviceProvider != null : !((Object)this$serviceProvider).equals(other$serviceProvider)) {
                return false;
            }
            com.eligible.model.claim.Claim this$claim = this.getClaim();
            com.eligible.model.claim.Claim other$claim = other.getClaim();
            return !(this$claim == null ? other$claim != null : !((Object)this$claim).equals(other$claim));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PaymentReport;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $referenceId = this.getReferenceId();
            result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
            String $effectiveDate = this.getEffectiveDate();
            result = result * 59 + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
            Payer $payer = this.getPayer();
            result = result * 59 + ($payer == null ? 43 : ((Object)$payer).hashCode());
            Financials $financials = this.getFinancials();
            result = result * 59 + ($financials == null ? 43 : ((Object)$financials).hashCode());
            Payee $payee = this.getPayee();
            result = result * 59 + ($payee == null ? 43 : ((Object)$payee).hashCode());
            Patient $patient = this.getPatient();
            result = result * 59 + ($patient == null ? 43 : ((Object)$patient).hashCode());
            Patient $correctedPatient = this.getCorrectedPatient();
            result = result * 59 + ($correctedPatient == null ? 43 : ((Object)$correctedPatient).hashCode());
            Patient $otherPatient = this.getOtherPatient();
            result = result * 59 + ($otherPatient == null ? 43 : ((Object)$otherPatient).hashCode());
            Provider $serviceProvider = this.getServiceProvider();
            result = result * 59 + ($serviceProvider == null ? 43 : ((Object)$serviceProvider).hashCode());
            com.eligible.model.claim.Claim $claim = this.getClaim();
            result = result * 59 + ($claim == null ? 43 : ((Object)$claim).hashCode());
            return result;
        }
    }

    public static class Acknowledgements
    extends APIResource {
        List<Acknowledgement> acknowledgements;
        String payerControlNumber;
        String referenceId;
        Integer page;
        Integer perPage;
        Integer numOfPages;
        Integer total;

        public static Acknowledgements retrieve(String referenceId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return Acknowledgements.retrieve(referenceId, null);
        }

        public static Acknowledgements query(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return Acknowledgements.query(params, null);
        }

        public static Acknowledgements retrieve(String referenceId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            String url = String.format("%s/%s", Acknowledgements.instanceURL(Claim.class, referenceId), Acknowledgements.className(Acknowledgements.class));
            return Acknowledgements.request(RequestMethod.GET, url, null, Acknowledgements.class, options);
        }

        public static Acknowledgements query(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            String url = String.format("%s/%s", Acknowledgements.classURL(Claim.class), Acknowledgements.className(Acknowledgements.class));
            return Acknowledgements.request(RequestMethod.GET, url, params, Acknowledgements.class, options);
        }

        public String getId() {
            return this.getReferenceId();
        }

        public List<Acknowledgement> getAcknowledgements() {
            return this.acknowledgements;
        }

        public String getPayerControlNumber() {
            return this.payerControlNumber;
        }

        public String getReferenceId() {
            return this.referenceId;
        }

        public Integer getPage() {
            return this.page;
        }

        public Integer getPerPage() {
            return this.perPage;
        }

        public Integer getNumOfPages() {
            return this.numOfPages;
        }

        public Integer getTotal() {
            return this.total;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Acknowledgements)) {
                return false;
            }
            Acknowledgements other = (Acknowledgements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Acknowledgement> this$acknowledgements = this.getAcknowledgements();
            List<Acknowledgement> other$acknowledgements = other.getAcknowledgements();
            if (this$acknowledgements == null ? other$acknowledgements != null : !((Object)this$acknowledgements).equals(other$acknowledgements)) {
                return false;
            }
            String this$payerControlNumber = this.getPayerControlNumber();
            String other$payerControlNumber = other.getPayerControlNumber();
            if (this$payerControlNumber == null ? other$payerControlNumber != null : !this$payerControlNumber.equals(other$payerControlNumber)) {
                return false;
            }
            String this$referenceId = this.getReferenceId();
            String other$referenceId = other.getReferenceId();
            if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
                return false;
            }
            Integer this$page = this.getPage();
            Integer other$page = other.getPage();
            if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
                return false;
            }
            Integer this$perPage = this.getPerPage();
            Integer other$perPage = other.getPerPage();
            if (this$perPage == null ? other$perPage != null : !((Object)this$perPage).equals(other$perPage)) {
                return false;
            }
            Integer this$numOfPages = this.getNumOfPages();
            Integer other$numOfPages = other.getNumOfPages();
            if (this$numOfPages == null ? other$numOfPages != null : !((Object)this$numOfPages).equals(other$numOfPages)) {
                return false;
            }
            Integer this$total = this.getTotal();
            Integer other$total = other.getTotal();
            return !(this$total == null ? other$total != null : !((Object)this$total).equals(other$total));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Acknowledgements;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Acknowledgement> $acknowledgements = this.getAcknowledgements();
            result = result * 59 + ($acknowledgements == null ? 43 : ((Object)$acknowledgements).hashCode());
            String $payerControlNumber = this.getPayerControlNumber();
            result = result * 59 + ($payerControlNumber == null ? 43 : $payerControlNumber.hashCode());
            String $referenceId = this.getReferenceId();
            result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
            Integer $page = this.getPage();
            result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
            Integer $perPage = this.getPerPage();
            result = result * 59 + ($perPage == null ? 43 : ((Object)$perPage).hashCode());
            Integer $numOfPages = this.getNumOfPages();
            result = result * 59 + ($numOfPages == null ? 43 : ((Object)$numOfPages).hashCode());
            Integer $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            return result;
        }
    }
}

