/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.model;

import com.eligible.exception.APIConnectionException;
import com.eligible.exception.APIException;
import com.eligible.exception.AuthenticationException;
import com.eligible.exception.InvalidRequestException;
import com.eligible.model.Address;
import com.eligible.model.coverage.Demographics;
import com.eligible.model.coverage.Insurance;
import com.eligible.model.coverage.Plan;
import com.eligible.model.coverage.Service;
import com.eligible.model.coverage.costestimates.CostEstimate;
import com.eligible.model.coverage.costestimates.SearchOptions;
import com.eligible.model.coverage.medicare.DateRange;
import com.eligible.model.coverage.medicare.HistoricDetails;
import com.eligible.model.coverage.medicare.RequestedProcedureCode;
import com.eligible.model.coverage.medicare.RequestedServiceType;
import com.eligible.net.APIResource;
import com.eligible.net.RequestMethod;
import com.eligible.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Coverage
extends APIResource {
    String createdAt;
    String eligibleId;
    List<String> knownIssues;
    Demographics demographics;
    Insurance insurance;
    Plan plan;
    List<Service> services;

    public static Coverage all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Coverage.all(params, null);
    }

    public static Medicare medicare(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Coverage.medicare(params, null);
    }

    public static CostEstimates costEstimate(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Coverage.costEstimate(params, null);
    }

    public static Coverage all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String url = String.format("%s/all", Coverage.singleClassURL(Coverage.class));
        return Coverage.request(RequestMethod.GET, url, params, Coverage.class, options);
    }

    public static Medicare medicare(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Medicare.all(params, options);
    }

    public static CostEstimates costEstimate(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return CostEstimates.all(params, options);
    }

    public String getId() {
        return this.getEligibleId();
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getEligibleId() {
        return this.eligibleId;
    }

    public List<String> getKnownIssues() {
        return this.knownIssues;
    }

    public Demographics getDemographics() {
        return this.demographics;
    }

    public Insurance getInsurance() {
        return this.insurance;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Coverage)) {
            return false;
        }
        Coverage other = (Coverage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$eligibleId = this.getEligibleId();
        String other$eligibleId = other.getEligibleId();
        if (this$eligibleId == null ? other$eligibleId != null : !this$eligibleId.equals(other$eligibleId)) {
            return false;
        }
        List<String> this$knownIssues = this.getKnownIssues();
        List<String> other$knownIssues = other.getKnownIssues();
        if (this$knownIssues == null ? other$knownIssues != null : !((Object)this$knownIssues).equals(other$knownIssues)) {
            return false;
        }
        Demographics this$demographics = this.getDemographics();
        Demographics other$demographics = other.getDemographics();
        if (this$demographics == null ? other$demographics != null : !((Object)this$demographics).equals(other$demographics)) {
            return false;
        }
        Insurance this$insurance = this.getInsurance();
        Insurance other$insurance = other.getInsurance();
        if (this$insurance == null ? other$insurance != null : !((Object)this$insurance).equals(other$insurance)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        List<Service> this$services = this.getServices();
        List<Service> other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Coverage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $eligibleId = this.getEligibleId();
        result = result * 59 + ($eligibleId == null ? 43 : $eligibleId.hashCode());
        List<String> $knownIssues = this.getKnownIssues();
        result = result * 59 + ($knownIssues == null ? 43 : ((Object)$knownIssues).hashCode());
        Demographics $demographics = this.getDemographics();
        result = result * 59 + ($demographics == null ? 43 : ((Object)$demographics).hashCode());
        Insurance $insurance = this.getInsurance();
        result = result * 59 + ($insurance == null ? 43 : ((Object)$insurance).hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        List<Service> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    public static class CostEstimates
    extends APIResource {
        String createdAt;
        String eligibleId;
        List<String> knownIssues;
        Demographics demographics;
        Insurance insurance;
        Plan plan;
        List<Service> services;
        SearchOptions searchOptions;
        List<CostEstimate> costEstimates;

        public static CostEstimates all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return CostEstimates.all(params, null);
        }

        public static CostEstimates all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            String url = String.format("%s/%s", CostEstimates.singleClassURL(Coverage.class), CostEstimates.className(CostEstimates.class));
            return CostEstimates.request(RequestMethod.GET, url, params, CostEstimates.class, options);
        }

        public String getId() {
            return this.getEligibleId();
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getEligibleId() {
            return this.eligibleId;
        }

        public List<String> getKnownIssues() {
            return this.knownIssues;
        }

        public Demographics getDemographics() {
            return this.demographics;
        }

        public Insurance getInsurance() {
            return this.insurance;
        }

        public Plan getPlan() {
            return this.plan;
        }

        public List<Service> getServices() {
            return this.services;
        }

        public SearchOptions getSearchOptions() {
            return this.searchOptions;
        }

        public List<CostEstimate> getCostEstimates() {
            return this.costEstimates;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CostEstimates)) {
                return false;
            }
            CostEstimates other = (CostEstimates)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$createdAt = this.getCreatedAt();
            String other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
                return false;
            }
            String this$eligibleId = this.getEligibleId();
            String other$eligibleId = other.getEligibleId();
            if (this$eligibleId == null ? other$eligibleId != null : !this$eligibleId.equals(other$eligibleId)) {
                return false;
            }
            List<String> this$knownIssues = this.getKnownIssues();
            List<String> other$knownIssues = other.getKnownIssues();
            if (this$knownIssues == null ? other$knownIssues != null : !((Object)this$knownIssues).equals(other$knownIssues)) {
                return false;
            }
            Demographics this$demographics = this.getDemographics();
            Demographics other$demographics = other.getDemographics();
            if (this$demographics == null ? other$demographics != null : !((Object)this$demographics).equals(other$demographics)) {
                return false;
            }
            Insurance this$insurance = this.getInsurance();
            Insurance other$insurance = other.getInsurance();
            if (this$insurance == null ? other$insurance != null : !((Object)this$insurance).equals(other$insurance)) {
                return false;
            }
            Plan this$plan = this.getPlan();
            Plan other$plan = other.getPlan();
            if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
                return false;
            }
            List<Service> this$services = this.getServices();
            List<Service> other$services = other.getServices();
            if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
                return false;
            }
            SearchOptions this$searchOptions = this.getSearchOptions();
            SearchOptions other$searchOptions = other.getSearchOptions();
            if (this$searchOptions == null ? other$searchOptions != null : !((Object)this$searchOptions).equals(other$searchOptions)) {
                return false;
            }
            List<CostEstimate> this$costEstimates = this.getCostEstimates();
            List<CostEstimate> other$costEstimates = other.getCostEstimates();
            return !(this$costEstimates == null ? other$costEstimates != null : !((Object)this$costEstimates).equals(other$costEstimates));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CostEstimates;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
            String $eligibleId = this.getEligibleId();
            result = result * 59 + ($eligibleId == null ? 43 : $eligibleId.hashCode());
            List<String> $knownIssues = this.getKnownIssues();
            result = result * 59 + ($knownIssues == null ? 43 : ((Object)$knownIssues).hashCode());
            Demographics $demographics = this.getDemographics();
            result = result * 59 + ($demographics == null ? 43 : ((Object)$demographics).hashCode());
            Insurance $insurance = this.getInsurance();
            result = result * 59 + ($insurance == null ? 43 : ((Object)$insurance).hashCode());
            Plan $plan = this.getPlan();
            result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
            List<Service> $services = this.getServices();
            result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
            SearchOptions $searchOptions = this.getSearchOptions();
            result = result * 59 + ($searchOptions == null ? 43 : ((Object)$searchOptions).hashCode());
            List<CostEstimate> $costEstimates = this.getCostEstimates();
            result = result * 59 + ($costEstimates == null ? 43 : ((Object)$costEstimates).hashCode());
            return result;
        }
    }

    public static class Medicare
    extends APIResource {
        String createdAt;
        String eligibleId;
        List<String> knownIssues;
        String dateOfDeath;
        String lastName;
        String firstName;
        String middleName;
        String memberId;
        String groupId;
        String groupName;
        String dob;
        String gender;
        String relationship;
        String relationshipCode;
        Address address;
        String payerName;
        String payerId;
        String planNumber;
        DateRange eligibiltyDates;
        DateRange inactivityDates;
        Map<String, String> planTypes;
        Map<String, Map> planDetails;
        List<RequestedServiceType> requestedServiceTypes;
        List<RequestedProcedureCode> requestedProcedureCodes;
        HistoricDetails history;

        public static Medicare all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return Medicare.all(params, null);
        }

        public static Medicare all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            String url = String.format("%s/%s", Medicare.singleClassURL(Coverage.class), Medicare.className(Medicare.class));
            return Medicare.request(RequestMethod.GET, url, params, Medicare.class, options);
        }

        public String getId() {
            return this.getEligibleId();
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getEligibleId() {
            return this.eligibleId;
        }

        public List<String> getKnownIssues() {
            return this.knownIssues;
        }

        public String getDateOfDeath() {
            return this.dateOfDeath;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public String getMemberId() {
            return this.memberId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getDob() {
            return this.dob;
        }

        public String getGender() {
            return this.gender;
        }

        public String getRelationship() {
            return this.relationship;
        }

        public String getRelationshipCode() {
            return this.relationshipCode;
        }

        public Address getAddress() {
            return this.address;
        }

        public String getPayerName() {
            return this.payerName;
        }

        public String getPayerId() {
            return this.payerId;
        }

        public String getPlanNumber() {
            return this.planNumber;
        }

        public DateRange getEligibiltyDates() {
            return this.eligibiltyDates;
        }

        public DateRange getInactivityDates() {
            return this.inactivityDates;
        }

        public Map<String, String> getPlanTypes() {
            return this.planTypes;
        }

        public Map<String, Map> getPlanDetails() {
            return this.planDetails;
        }

        public List<RequestedServiceType> getRequestedServiceTypes() {
            return this.requestedServiceTypes;
        }

        public List<RequestedProcedureCode> getRequestedProcedureCodes() {
            return this.requestedProcedureCodes;
        }

        public HistoricDetails getHistory() {
            return this.history;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Medicare)) {
                return false;
            }
            Medicare other = (Medicare)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$createdAt = this.getCreatedAt();
            String other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
                return false;
            }
            String this$eligibleId = this.getEligibleId();
            String other$eligibleId = other.getEligibleId();
            if (this$eligibleId == null ? other$eligibleId != null : !this$eligibleId.equals(other$eligibleId)) {
                return false;
            }
            List<String> this$knownIssues = this.getKnownIssues();
            List<String> other$knownIssues = other.getKnownIssues();
            if (this$knownIssues == null ? other$knownIssues != null : !((Object)this$knownIssues).equals(other$knownIssues)) {
                return false;
            }
            String this$dateOfDeath = this.getDateOfDeath();
            String other$dateOfDeath = other.getDateOfDeath();
            if (this$dateOfDeath == null ? other$dateOfDeath != null : !this$dateOfDeath.equals(other$dateOfDeath)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$middleName = this.getMiddleName();
            String other$middleName = other.getMiddleName();
            if (this$middleName == null ? other$middleName != null : !this$middleName.equals(other$middleName)) {
                return false;
            }
            String this$memberId = this.getMemberId();
            String other$memberId = other.getMemberId();
            if (this$memberId == null ? other$memberId != null : !this$memberId.equals(other$memberId)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$groupName = this.getGroupName();
            String other$groupName = other.getGroupName();
            if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
                return false;
            }
            String this$dob = this.getDob();
            String other$dob = other.getDob();
            if (this$dob == null ? other$dob != null : !this$dob.equals(other$dob)) {
                return false;
            }
            String this$gender = this.getGender();
            String other$gender = other.getGender();
            if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
                return false;
            }
            String this$relationship = this.getRelationship();
            String other$relationship = other.getRelationship();
            if (this$relationship == null ? other$relationship != null : !this$relationship.equals(other$relationship)) {
                return false;
            }
            String this$relationshipCode = this.getRelationshipCode();
            String other$relationshipCode = other.getRelationshipCode();
            if (this$relationshipCode == null ? other$relationshipCode != null : !this$relationshipCode.equals(other$relationshipCode)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$payerName = this.getPayerName();
            String other$payerName = other.getPayerName();
            if (this$payerName == null ? other$payerName != null : !this$payerName.equals(other$payerName)) {
                return false;
            }
            String this$payerId = this.getPayerId();
            String other$payerId = other.getPayerId();
            if (this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId)) {
                return false;
            }
            String this$planNumber = this.getPlanNumber();
            String other$planNumber = other.getPlanNumber();
            if (this$planNumber == null ? other$planNumber != null : !this$planNumber.equals(other$planNumber)) {
                return false;
            }
            DateRange this$eligibiltyDates = this.getEligibiltyDates();
            DateRange other$eligibiltyDates = other.getEligibiltyDates();
            if (this$eligibiltyDates == null ? other$eligibiltyDates != null : !((Object)this$eligibiltyDates).equals(other$eligibiltyDates)) {
                return false;
            }
            DateRange this$inactivityDates = this.getInactivityDates();
            DateRange other$inactivityDates = other.getInactivityDates();
            if (this$inactivityDates == null ? other$inactivityDates != null : !((Object)this$inactivityDates).equals(other$inactivityDates)) {
                return false;
            }
            Map<String, String> this$planTypes = this.getPlanTypes();
            Map<String, String> other$planTypes = other.getPlanTypes();
            if (this$planTypes == null ? other$planTypes != null : !((Object)this$planTypes).equals(other$planTypes)) {
                return false;
            }
            Map<String, Map> this$planDetails = this.getPlanDetails();
            Map<String, Map> other$planDetails = other.getPlanDetails();
            if (this$planDetails == null ? other$planDetails != null : !((Object)this$planDetails).equals(other$planDetails)) {
                return false;
            }
            List<RequestedServiceType> this$requestedServiceTypes = this.getRequestedServiceTypes();
            List<RequestedServiceType> other$requestedServiceTypes = other.getRequestedServiceTypes();
            if (this$requestedServiceTypes == null ? other$requestedServiceTypes != null : !((Object)this$requestedServiceTypes).equals(other$requestedServiceTypes)) {
                return false;
            }
            List<RequestedProcedureCode> this$requestedProcedureCodes = this.getRequestedProcedureCodes();
            List<RequestedProcedureCode> other$requestedProcedureCodes = other.getRequestedProcedureCodes();
            if (this$requestedProcedureCodes == null ? other$requestedProcedureCodes != null : !((Object)this$requestedProcedureCodes).equals(other$requestedProcedureCodes)) {
                return false;
            }
            HistoricDetails this$history = this.getHistory();
            HistoricDetails other$history = other.getHistory();
            return !(this$history == null ? other$history != null : !((Object)this$history).equals(other$history));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Medicare;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
            String $eligibleId = this.getEligibleId();
            result = result * 59 + ($eligibleId == null ? 43 : $eligibleId.hashCode());
            List<String> $knownIssues = this.getKnownIssues();
            result = result * 59 + ($knownIssues == null ? 43 : ((Object)$knownIssues).hashCode());
            String $dateOfDeath = this.getDateOfDeath();
            result = result * 59 + ($dateOfDeath == null ? 43 : $dateOfDeath.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $middleName = this.getMiddleName();
            result = result * 59 + ($middleName == null ? 43 : $middleName.hashCode());
            String $memberId = this.getMemberId();
            result = result * 59 + ($memberId == null ? 43 : $memberId.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $groupName = this.getGroupName();
            result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
            String $dob = this.getDob();
            result = result * 59 + ($dob == null ? 43 : $dob.hashCode());
            String $gender = this.getGender();
            result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
            String $relationship = this.getRelationship();
            result = result * 59 + ($relationship == null ? 43 : $relationship.hashCode());
            String $relationshipCode = this.getRelationshipCode();
            result = result * 59 + ($relationshipCode == null ? 43 : $relationshipCode.hashCode());
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $payerName = this.getPayerName();
            result = result * 59 + ($payerName == null ? 43 : $payerName.hashCode());
            String $payerId = this.getPayerId();
            result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
            String $planNumber = this.getPlanNumber();
            result = result * 59 + ($planNumber == null ? 43 : $planNumber.hashCode());
            DateRange $eligibiltyDates = this.getEligibiltyDates();
            result = result * 59 + ($eligibiltyDates == null ? 43 : ((Object)$eligibiltyDates).hashCode());
            DateRange $inactivityDates = this.getInactivityDates();
            result = result * 59 + ($inactivityDates == null ? 43 : ((Object)$inactivityDates).hashCode());
            Map<String, String> $planTypes = this.getPlanTypes();
            result = result * 59 + ($planTypes == null ? 43 : ((Object)$planTypes).hashCode());
            Map<String, Map> $planDetails = this.getPlanDetails();
            result = result * 59 + ($planDetails == null ? 43 : ((Object)$planDetails).hashCode());
            List<RequestedServiceType> $requestedServiceTypes = this.getRequestedServiceTypes();
            result = result * 59 + ($requestedServiceTypes == null ? 43 : ((Object)$requestedServiceTypes).hashCode());
            List<RequestedProcedureCode> $requestedProcedureCodes = this.getRequestedProcedureCodes();
            result = result * 59 + ($requestedProcedureCodes == null ? 43 : ((Object)$requestedProcedureCodes).hashCode());
            HistoricDetails $history = this.getHistory();
            result = result * 59 + ($history == null ? 43 : ((Object)$history).hashCode());
            return result;
        }
    }
}

