/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.model;

import com.eligible.exception.APIConnectionException;
import com.eligible.exception.APIException;
import com.eligible.exception.AuthenticationException;
import com.eligible.exception.InvalidRequestException;
import com.eligible.model.payer.Endpoint;
import com.eligible.net.APIResource;
import com.eligible.net.RequestMethod;
import com.eligible.net.RequestOptions;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public class Payer
extends APIResource {
    String payerId;
    List<String> names;
    String createdAt;
    String updatedAt;
    List<Endpoint> supportedEndpoints;

    public static Payer retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Payer.retrieve(id, null);
    }

    public static List<Payer> all() throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Payer.all(null);
    }

    public static List<SearchOptions> searchOptions() throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Payer.searchOptions((RequestOptions)null);
    }

    public static SearchOptions searchOptions(String payerId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Payer.searchOptions(payerId, null);
    }

    public static Payer retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Payer.request(RequestMethod.GET, Payer.instanceURL(Payer.class, id), null, Payer.class, options);
    }

    public static List<Payer> all(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Type listType = new TypeToken<List<Payer>>(){}.getType();
        return (List)Payer.request(RequestMethod.GET, Payer.classURL(Payer.class), null, listType, options);
    }

    public static List<SearchOptions> searchOptions(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return SearchOptions.all(options);
    }

    public static SearchOptions searchOptions(String payerId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return SearchOptions.retrieve(payerId, options);
    }

    public String getId() {
        return this.getPayerId();
    }

    public String getPayerId() {
        return this.payerId;
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public List<Endpoint> getSupportedEndpoints() {
        return this.supportedEndpoints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payer)) {
            return false;
        }
        Payer other = (Payer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$payerId = this.getPayerId();
        String other$payerId = other.getPayerId();
        if (this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) {
            return false;
        }
        List<Endpoint> this$supportedEndpoints = this.getSupportedEndpoints();
        List<Endpoint> other$supportedEndpoints = other.getSupportedEndpoints();
        return !(this$supportedEndpoints == null ? other$supportedEndpoints != null : !((Object)this$supportedEndpoints).equals(other$supportedEndpoints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Payer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $payerId = this.getPayerId();
        result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        List<Endpoint> $supportedEndpoints = this.getSupportedEndpoints();
        result = result * 59 + ($supportedEndpoints == null ? 43 : ((Object)$supportedEndpoints).hashCode());
        return result;
    }

    public static class SearchOptions
    extends APIResource {
        String payerId;
        List<List<String>> searchOptions;

        public static List<SearchOptions> all() throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return SearchOptions.all(null);
        }

        public static SearchOptions retrieve(String payerId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return SearchOptions.retrieve(payerId, null);
        }

        public static List<SearchOptions> all(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            Type listType = new TypeToken<List<SearchOptions>>(){}.getType();
            return (List)SearchOptions.request(RequestMethod.GET, SearchOptions.classURL(SearchOptions.class), null, listType, options);
        }

        public static SearchOptions retrieve(String payerId, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
            return SearchOptions.request(RequestMethod.GET, SearchOptions.instanceURL(SearchOptions.class, payerId), null, SearchOptions.class, options);
        }

        protected static String classURL(Class<?> clazz) {
            return String.format("%s/%s", APIResource.classURL(Payer.class), SearchOptions.className(clazz));
        }

        protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
            return String.format("%s/%s", APIResource.instanceURL(Payer.class, id), SearchOptions.className(clazz));
        }

        public String getId() {
            return this.getPayerId();
        }

        public String getPayerId() {
            return this.payerId;
        }

        public List<List<String>> getSearchOptions() {
            return this.searchOptions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchOptions)) {
                return false;
            }
            SearchOptions other = (SearchOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$payerId = this.getPayerId();
            String other$payerId = other.getPayerId();
            if (this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId)) {
                return false;
            }
            List<List<String>> this$searchOptions = this.getSearchOptions();
            List<List<String>> other$searchOptions = other.getSearchOptions();
            return !(this$searchOptions == null ? other$searchOptions != null : !((Object)this$searchOptions).equals(other$searchOptions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $payerId = this.getPayerId();
            result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
            List<List<String>> $searchOptions = this.getSearchOptions();
            result = result * 59 + ($searchOptions == null ? 43 : ((Object)$searchOptions).hashCode());
            return result;
        }
    }
}

