/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.net;

import com.eligible.Eligible;
import com.eligible.exception.APIConnectionException;
import com.eligible.exception.APIException;
import com.eligible.exception.AuthenticationException;
import com.eligible.exception.InvalidRequestException;
import com.eligible.json.deserializer.DatesDeserializer;
import com.eligible.json.deserializer.EligibleObjectTypeAdapterFactory;
import com.eligible.json.deserializer.FinancialFlowListDeserializer;
import com.eligible.model.EligibleObject;
import com.eligible.model.coverage.Dates;
import com.eligible.model.coverage.FinancialFlow;
import com.eligible.net.EligibleResponseGetter;
import com.eligible.net.LiveEligibleResponseGetter;
import com.eligible.net.RequestMethod;
import com.eligible.net.RequestOptions;
import com.eligible.net.RequestType;
import com.eligible.util.NetworkUtil;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public abstract class APIResource
extends EligibleObject {
    private static EligibleResponseGetter eligibleResponseGetter = new LiveEligibleResponseGetter();
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapterFactory((TypeAdapterFactory)new EligibleObjectTypeAdapterFactory()).registerTypeAdapter(Dates.class, (Object)new DatesDeserializer()).registerTypeAdapter(new TypeToken<List<FinancialFlow>>(){}.getType(), (Object)new FinancialFlowListDeserializer()).create();

    protected static String className(Class<?> clazz) {
        String className;
        switch (className = clazz.getSimpleName().toLowerCase()) {
            case "searchoptions": {
                return "search_options";
            }
            case "costestimates": {
                return "cost_estimates";
            }
            case "paymentreport": {
                return "payment_report";
            }
            case "paymentreports": {
                return "payment_reports";
            }
            case "paymentstatus": {
                return "payment/status";
            }
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) {
        return APIResource.singleClassURL(clazz, Eligible.getApiBase());
    }

    protected static String singleClassURL(Class<?> clazz, String apiBase) {
        return String.format("%s/v1.5/%s", apiBase, APIResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        return APIResource.classURL(clazz, Eligible.getApiBase());
    }

    protected static String classURL(Class<?> clazz, String apiBase) {
        return String.format("%ss", APIResource.singleClassURL(clazz, apiBase));
    }

    protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
        return APIResource.instanceURL(clazz, id, Eligible.getApiBase());
    }

    protected static String instanceURL(Class<?> clazz, String id, String apiBase) throws InvalidRequestException {
        try {
            return String.format("%s/%s", APIResource.classURL(clazz, apiBase), NetworkUtil.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@eligible.com for assistance.", null, e);
        }
    }

    protected static <T> T multipartRequest(RequestMethod method, String url, Map<String, Object> params, Type typeOfT, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return eligibleResponseGetter.request(method, url, params, typeOfT, RequestType.MULTIPART, options);
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Type typeOfT, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return eligibleResponseGetter.request(method, url, params, typeOfT, RequestType.NORMAL, options);
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> typeOfT, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return APIResource.request(method, url, params, typeOfT, options);
    }

    public static void setEligibleResponseGetter(EligibleResponseGetter eligibleResponseGetter) {
        APIResource.eligibleResponseGetter = eligibleResponseGetter;
    }
}

