/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.net;

import com.eligible.Eligible;
import com.eligible.exception.APIConnectionException;
import com.eligible.exception.APIException;
import com.eligible.exception.AuthenticationException;
import com.eligible.exception.InvalidRequestException;
import com.eligible.model.EligibleObject;
import com.eligible.net.APIResource;
import com.eligible.net.EligibleResponse;
import com.eligible.net.EligibleResponseGetter;
import com.eligible.net.MultipartProcessor;
import com.eligible.net.RequestMethod;
import com.eligible.net.RequestOptions;
import com.eligible.net.RequestType;
import com.eligible.util.NetworkUtil;
import com.eligible.util.StringUtil;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;

public class LiveEligibleResponseGetter
implements EligibleResponseGetter {
    public static final String CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME = "com.eligible.net.customURLStreamHandler";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final int CONNECTION_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int READ_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(80L);
    private static final Double GAE_DEADLINE = 55.0;

    @Override
    public <T> T request(RequestMethod method, String url, Map<String, Object> params, Type typeOfT, RequestType type, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return LiveEligibleResponseGetter.requestInternal(method, url, params, typeOfT, type, options);
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", NetworkUtil.urlEncode(k), NetworkUtil.urlEncode(v));
    }

    static Map<String, String> getHeaders(RequestOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String apiVersion = options.getApiVersion();
        headers.put("Accept-Charset", "UTF-8");
        headers.put("Accept", "application/json");
        headers.put("User-Agent", String.format("Eligible/%s JavaBindings/%s", apiVersion, "1.2.0"));
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "1.2.0");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Eligible");
        headers.put("X-Eligible-Client-User-Agent", APIResource.GSON.toJson(propertyMap));
        if (apiVersion != null) {
            headers.put("Eligible-Version", apiVersion);
        }
        return headers;
    }

    private static HttpURLConnection createEligibleConnection(String url, RequestOptions options) throws IOException {
        HttpURLConnection conn;
        URL eligibleURL;
        String customURLStreamHandlerClassName = System.getProperty(CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME, null);
        if (customURLStreamHandlerClassName != null) {
            try {
                Class<?> clazz = Class.forName(customURLStreamHandlerClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                URLStreamHandler customHandler = (URLStreamHandler)constructor.newInstance(new Object[0]);
                eligibleURL = new URL(null, url, customHandler);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new IOException(e);
            }
        } else {
            eligibleURL = new URL(url);
        }
        if (Eligible.getConnectionProxy() != null) {
            conn = (HttpURLConnection)eligibleURL.openConnection(Eligible.getConnectionProxy());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return Eligible.getProxyCredential();
                }
            });
        } else {
            conn = (HttpURLConnection)eligibleURL.openConnection();
        }
        conn.setConnectTimeout(CONNECTION_TIMEOUT_MILLIS);
        conn.setReadTimeout(READ_TIMEOUT_MILLIS);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : LiveEligibleResponseGetter.getHeaders(options).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static String formatURL(String url, String query) {
        if (StringUtil.isEmpty(query)) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private static HttpURLConnection createGetConnection(String url, String query, RequestOptions options) throws IOException {
        String getURL = LiveEligibleResponseGetter.formatURL(url, query);
        HttpURLConnection conn = LiveEligibleResponseGetter.createEligibleConnection(getURL, options);
        conn.setRequestMethod("GET");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostConnection(String url, String query, RequestOptions options) throws IOException {
        HttpURLConnection conn = LiveEligibleResponseGetter.createEligibleConnection(url, options);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/json;charset=%s", "UTF-8"));
        try (OutputStream output = null;){
            output = conn.getOutputStream();
            output.write(query.getBytes("UTF-8"));
        }
        return conn;
    }

    private static HttpURLConnection createDeleteConnection(String url, String query, RequestOptions options) throws IOException {
        String deleteUrl = LiveEligibleResponseGetter.formatURL(url, query);
        HttpURLConnection conn = LiveEligibleResponseGetter.createEligibleConnection(deleteUrl, options);
        conn.setRequestMethod("DELETE");
        return conn;
    }

    static String createHtmlQuery(Map<String, Object> params, RequestOptions options) throws UnsupportedEncodingException, InvalidRequestException {
        Map<String, String> flatParams = LiveEligibleResponseGetter.flattenParams(params);
        flatParams.put("api_key", options.getApiKey());
        flatParams.put("test", String.valueOf(options.isTest()));
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(LiveEligibleResponseGetter.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    static String createJsonPayload(Map<String, Object> params, RequestOptions options) throws InvalidRequestException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("api_key", options.getApiKey());
        params.put("test", String.valueOf(options.isTest()));
        return APIResource.GSON.toJson(params);
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) throws InvalidRequestException {
        if (params == null) {
            return new HashMap<String, String>();
        }
        LinkedHashMap<String, String> flatParams = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            LinkedHashMap<String, Object> flatNestedMap;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                flatNestedMap = new LinkedHashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(LiveEligibleResponseGetter.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof List) {
                flatNestedMap = new LinkedHashMap();
                Iterator it = ((List)value).iterator();
                int index = 0;
                while (it.hasNext()) {
                    flatNestedMap.put(String.format("%s[%s]", key, index), it.next());
                    ++index;
                }
                flatParams.putAll(LiveEligibleResponseGetter.flattenParams(flatNestedMap));
                continue;
            }
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + key + "' to an empty string. " + "We interpret empty strings as null in requests. " + "You may set '" + key + "' to null to delete the property.", key);
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, "UTF-8").useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static EligibleResponse makeURLConnectionRequest(RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws APIConnectionException, InvalidRequestException {
        String query;
        try {
            query = LiveEligibleResponseGetter.createHtmlQuery(params, options);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@eligible.com for assistance.", null, e);
        }
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = LiveEligibleResponseGetter.createGetConnection(url, query, options);
                    break;
                }
                case POST: {
                    String payload = LiveEligibleResponseGetter.createJsonPayload(params, options);
                    conn = LiveEligibleResponseGetter.createPostConnection(url, payload, options);
                    break;
                }
                case DELETE: {
                    conn = LiveEligibleResponseGetter.createDeleteConnection(url, query, options);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This indicates a bug in the Eligible bindings. Please contact support@eligible.com for assistance.", new Object[]{method}));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? LiveEligibleResponseGetter.getResponseBody(conn.getInputStream()) : LiveEligibleResponseGetter.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            EligibleResponse eligibleResponse = new EligibleResponse(rCode, rBody, headers);
            return eligibleResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Eligible (%s): %s Please check your internet connection and try again. If this problem persists,you should check Eligible's service status at https://twitter.com/eligibleapi, or let us know at support@eligible.com.", Eligible.getApiBase(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T requestInternal(RequestMethod method, String url, Map<String, Object> params, Type typeOfT, RequestType type, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        if (options == null) {
            options = RequestOptions.getDefault();
        }
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        String apiKey = options.getApiKey();
        if (StringUtil.isBlank(apiKey)) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Eligible.apiKey = <API-KEY>'. You can generate API keys from the Eligible web interface. See https://eligible.com/profile/access_keys for details or email support@eligible.com if you have questions.");
        }
        try {
            EligibleResponse response;
            switch (type) {
                case NORMAL: {
                    response = LiveEligibleResponseGetter.getEligibleResponse(method, url, params, options);
                    break;
                }
                case MULTIPART: {
                    response = LiveEligibleResponseGetter.getMultipartEligibleResponse(method, url, params, options);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid APIResource request type. This indicates a bug in the Eligible bindings. Please contact support@eligible.com for assistance.");
                }
            }
            int rCode = response.getResponseCode();
            String rBody = response.getResponseBody();
            if (rCode < 200 || rCode >= 300) {
                LiveEligibleResponseGetter.handleAPIError(rBody, rCode);
            }
            Object object = APIResource.GSON.fromJson(rBody, typeOfT);
            return (T)object;
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    private static EligibleResponse getEligibleResponse(RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws InvalidRequestException, APIConnectionException, APIException {
        try {
            return LiveEligibleResponseGetter.makeURLConnectionRequest(method, url, params, options);
        }
        catch (ClassCastException ce) {
            String appEngineEnv = System.getProperty("com.google.appengine.runtime.environment", null);
            if (appEngineEnv != null) {
                return LiveEligibleResponseGetter.makeAppEngineRequest(method, url, params, options);
            }
            throw ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EligibleResponse getMultipartEligibleResponse(RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws InvalidRequestException, APIConnectionException, APIException {
        if (method != RequestMethod.POST) {
            throw new InvalidRequestException("Multipart requests for HTTP methods other than POST are currently not supported.");
        }
        HttpURLConnection conn = null;
        try {
            conn = LiveEligibleResponseGetter.createEligibleConnection(url, options);
            String boundary = NetworkUtil.getBoundary();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", String.format("multipart/form-data; boundary=%s", boundary));
            MultipartProcessor multipartProcessor = null;
            try {
                multipartProcessor = new MultipartProcessor(conn, boundary, "UTF-8");
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof File) {
                        File currentFile = (File)value;
                        if (!currentFile.exists()) {
                            throw new InvalidRequestException("File for key " + key + " must exist.");
                        }
                        if (!currentFile.isFile()) {
                            throw new InvalidRequestException("File for key " + key + " must be a file and not a directory.");
                        }
                        if (!currentFile.canRead()) {
                            throw new InvalidRequestException("Must have read permissions on file for key " + key + ".");
                        }
                        multipartProcessor.addFileField(key, currentFile);
                        continue;
                    }
                    multipartProcessor.addFormField(key, (String)value);
                }
            }
            finally {
                if (multipartProcessor != null) {
                    multipartProcessor.finish();
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? LiveEligibleResponseGetter.getResponseBody(conn.getInputStream()) : LiveEligibleResponseGetter.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            EligibleResponse eligibleResponse = new EligibleResponse(rCode, rBody, headers);
            return eligibleResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Eligible (%s): %s Please check your internet connection and try again. If this problem persists,you should check Eligible's service status at https://twitter.com/eligibleapi, or let us know at support@eligible.com.", Eligible.getApiBase(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void handleAPIError(String rBody, int rCode) throws InvalidRequestException, AuthenticationException, APIException {
        JsonElement rBodyJson = APIResource.GSON.toJsonTree((Object)rBody);
        String message = null;
        if (rBodyJson.isJsonObject()) {
            Error error = (Error)APIResource.GSON.fromJson(rBody, Error.class);
            message = error.getError();
        } else if (rBodyJson.isJsonPrimitive()) {
            message = rBodyJson.getAsString();
        }
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(message);
            }
            case 404: {
                throw new InvalidRequestException(message);
            }
            case 401: {
                throw new AuthenticationException(message);
            }
        }
        throw new APIException(message);
    }

    private static EligibleResponse makeAppEngineRequest(RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws APIException, InvalidRequestException {
        String query;
        String unknownErrorMessage = "Sorry, an unknown error occurred while trying to use the Google App Engine runtime. Please contact support@eligible.com for assistance.";
        try {
            query = LiveEligibleResponseGetter.createHtmlQuery(params, options);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@eligible.com for assistance.", null, e);
        }
        try {
            Object fetchOptions;
            if (method == RequestMethod.GET || method == RequestMethod.DELETE) {
                url = String.format("%s?%s", url, query);
            }
            URL fetchURL = new URL(url);
            Class<?> requestMethodClass = Class.forName("com.google.appengine.api.urlfetch.HTTPMethod");
            Object httpMethod = requestMethodClass.getDeclaredField(method.name()).get(null);
            Class<?> fetchOptionsBuilderClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions$Builder");
            try {
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("validateCertificate", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                System.err.println("Warning: this App Engine SDK version does not allow verification of SSL certificates;this exposes you to a MITM attack. Please upgrade your App Engine SDK to >=1.5.0. If you have questions, contact support@eligible.com.");
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("withDefaults", new Class[0]).invoke(null, new Object[0]);
            }
            Class<?> fetchOptionsClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions");
            fetchOptionsClass.getDeclaredMethod("setDeadline", Double.class).invoke(fetchOptions, GAE_DEADLINE);
            Class<?> requestClass = Class.forName("com.google.appengine.api.urlfetch.HTTPRequest");
            Object request = requestClass.getDeclaredConstructor(URL.class, requestMethodClass, fetchOptionsClass).newInstance(fetchURL, httpMethod, fetchOptions);
            if (method == RequestMethod.POST) {
                requestClass.getDeclaredMethod("setPayload", byte[].class).invoke(request, new Object[]{LiveEligibleResponseGetter.createJsonPayload(params, options).getBytes()});
            }
            for (Map.Entry<String, String> header : LiveEligibleResponseGetter.getHeaders(options).entrySet()) {
                Class<?> httpHeaderClass = Class.forName("com.google.appengine.api.urlfetch.HTTPHeader");
                Object reqHeader = httpHeaderClass.getDeclaredConstructor(String.class, String.class).newInstance(header.getKey(), header.getValue());
                requestClass.getDeclaredMethod("setHeader", httpHeaderClass).invoke(request, reqHeader);
            }
            Class<?> urlFetchFactoryClass = Class.forName("com.google.appengine.api.urlfetch.URLFetchServiceFactory");
            Object urlFetchService = urlFetchFactoryClass.getDeclaredMethod("getURLFetchService", new Class[0]).invoke(null, new Object[0]);
            Method fetchMethod = urlFetchService.getClass().getDeclaredMethod("fetch", requestClass);
            fetchMethod.setAccessible(true);
            Object response = fetchMethod.invoke(urlFetchService, request);
            int responseCode = (Integer)response.getClass().getDeclaredMethod("getResponseCode", new Class[0]).invoke(response, new Object[0]);
            String body = new String((byte[])response.getClass().getDeclaredMethod("getContent", new Class[0]).invoke(response, new Object[0]), "UTF-8");
            return new EligibleResponse(responseCode, body);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | ReflectiveOperationException | SecurityException | MalformedURLException e) {
            throw new APIException(unknownErrorMessage, e);
        }
    }

    private static class Error
    extends EligibleObject {
        private String error;

        private Error() {
        }

        public String getError() {
            return this.error;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Error;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }
    }
}

