/*
 * Decompiled with CFR 0.152.
 */
package com.eligible.net;

import com.eligible.Eligible;
import com.eligible.util.StringUtil;
import java.beans.ConstructorProperties;

public class RequestOptions {
    private final String apiKey;
    private final String apiVersion;
    private final boolean test;

    public static RequestOptions getDefault() {
        return new RequestOptions(Eligible.apiKey, Eligible.apiVersion, Eligible.isTest);
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder(this.apiKey, this.apiVersion, this.test);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean isTest() {
        return this.test;
    }

    @ConstructorProperties(value={"apiKey", "apiVersion", "test"})
    public RequestOptions(String apiKey, String apiVersion, boolean test) {
        this.apiKey = apiKey;
        this.apiVersion = apiVersion;
        this.test = test;
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Eligible.apiKey;
        private String apiVersion = Eligible.apiVersion;
        private boolean test = Eligible.isTest;

        public RequestOptions build() {
            return new RequestOptions(StringUtil.normalizeString(this.apiKey), StringUtil.normalizeString(this.apiVersion), this.test);
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public boolean isTest() {
            return this.test;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public RequestOptionsBuilder setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public RequestOptionsBuilder setTest(boolean test) {
            this.test = test;
            return this;
        }

        @ConstructorProperties(value={"apiKey", "apiVersion", "test"})
        public RequestOptionsBuilder(String apiKey, String apiVersion, boolean test) {
            this.apiKey = apiKey;
            this.apiVersion = apiVersion;
            this.test = test;
        }

        public RequestOptionsBuilder() {
        }
    }
}

