/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises;

import com.englishtown.promises.DeferredProgress;
import com.englishtown.promises.ProgressPromise;
import com.englishtown.promises.PromiseExt;
import com.englishtown.promises.PromiseState;
import com.englishtown.promises.Reducer;
import com.englishtown.promises.Resolver;
import com.englishtown.promises.Runnable;
import com.englishtown.promises.Runnable2;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.Value;
import com.englishtown.promises.ValueHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OldWhenProgress<TResolve, TProgress> {
    private final Runnable<ProgressPromise<TResolve, TProgress>, TResolve> identity = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

        @Override
        public ProgressPromise<TResolve, TProgress> run(TResolve value) {
            return OldWhenProgress.this.resolve(value);
        }
    };

    public ProgressPromise<TResolve, TProgress> when(TResolve value) {
        return this.when(value, null);
    }

    public ProgressPromise<TResolve, TProgress> when(TResolve value, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
        return this.when(this.resolve(value), onFulfilled);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise) {
        return this.when(promise, null, null, null);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
        return this.when(promise, onFulfilled, null, null);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected) {
        return this.when(promise, onFulfilled, onRejected, null);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
        return this.resolve(promise).then(onFulfilled, onRejected, onProgress);
    }

    public ProgressPromise<TResolve, TProgress> resolve(TResolve value) {
        return this.fulfilled(value);
    }

    public ProgressPromise<TResolve, TProgress> resolvePromise(Thenable<TResolve, TProgress> promise) {
        return this.resolve(promise);
    }

    private PromiseImpl resolve(Thenable<TResolve, TProgress> promise) {
        if (promise == null) {
            return this.fulfilled(null);
        }
        if (PromiseImpl.class.isInstance(promise)) {
            return (PromiseImpl)promise;
        }
        return this.assimilate(promise);
    }

    private PromiseImpl assimilate(Thenable<TResolve, TProgress> thenable) {
        final DeferredImpl d = this.deferInner();
        try {
            thenable.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                    d.resolver.resolve(value);
                    return null;
                }
            }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                    d.resolver.reject(reason);
                    return null;
                }
            }, new Runnable<Value<TProgress>, Value<TProgress>>(){

                @Override
                public Value<TProgress> run(Value<TProgress> update) {
                    d.resolver.notify(update);
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            d.resolver.reject(e);
        }
        return d.promise;
    }

    public ProgressPromise<TResolve, TProgress> reject(Thenable<TResolve, TProgress> promise) {
        return this.when(promise, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                return OldWhenProgress.this.rejected(new Value(value));
            }
        });
    }

    public ProgressPromise<TResolve, TProgress> reject(TResolve value) {
        return this.reject((TResolve)this.resolve(value));
    }

    public ProgressPromise<TResolve, TProgress> reject(Value<TResolve> value) {
        return this.rejected(value);
    }

    public ProgressPromise<TResolve, TProgress> reject(Throwable error) {
        return this.rejected(new Value(error));
    }

    private PromiseImpl fulfilled(final TResolve value) {
        return this.createPromise(new Thenable<TResolve, TProgress>(){

            @Override
            public ProgressPromise<TResolve, TProgress> then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
                try {
                    return onFulfilled != null ? OldWhenProgress.this.resolve(onFulfilled.run(value)) : OldWhenProgress.this.resolve(value);
                }
                catch (RuntimeException e) {
                    return OldWhenProgress.this.rejected(new Value(e));
                }
            }
        });
    }

    private PromiseImpl rejected(final Value<TResolve> reason) {
        return this.createPromise(new Thenable<TResolve, TProgress>(){

            @Override
            public ProgressPromise<TResolve, TProgress> then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
                try {
                    return onRejected != null ? OldWhenProgress.this.resolve(onRejected.run(reason)) : OldWhenProgress.this.rejected(reason);
                }
                catch (RuntimeException e) {
                    return OldWhenProgress.this.rejected(new Value(e));
                }
            }
        });
    }

    public DeferredProgress<TResolve, TProgress> defer() {
        return this.deferInner();
    }

    private DeferredImpl deferInner() {
        final ArrayList handlers = new ArrayList();
        final ArrayList progressHandlers = new ArrayList();
        final ValueHolder _then = new ValueHolder();
        _then.value = new Thenable<TResolve, TProgress>(){

            @Override
            public ProgressPromise<TResolve, TProgress> then(final Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, final Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, final Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
                final ValueHolder progressHandler = new ValueHolder();
                final DeferredImpl deferred = OldWhenProgress.this.deferInner();
                progressHandler.value = onProgress != null ? new Runnable<Value<TProgress>, Value<TProgress>>(){

                    @Override
                    public Value<TProgress> run(Value<TProgress> update) {
                        try {
                            deferred.resolver.notify((Value)onProgress.run(update));
                        }
                        catch (RuntimeException e) {
                            deferred.resolver.notify(new Value(e));
                        }
                        return null;
                    }
                } : new Runnable<Value<TProgress>, Value<TProgress>>(){

                    @Override
                    public Value<TProgress> run(Value<TProgress> update) {
                        deferred.resolver.notify(update);
                        return null;
                    }
                };
                handlers.add(new Runnable<Void, ProgressPromise<TResolve, TProgress>>(){

                    @Override
                    public Void run(ProgressPromise<TResolve, TProgress> promise) {
                        promise.then(onFulfilled, onRejected).then(deferred.resolver.resolve, deferred.resolver.reject, (Runnable)progressHandler.value);
                        return null;
                    }
                });
                progressHandlers.add(progressHandler.value);
                return deferred.promise;
            }
        };
        final ValueHolder _notify = new ValueHolder();
        _notify.value = new Runnable<Value<TProgress>, Value<TProgress>>(){

            @Override
            public Value<TProgress> run(Value<TProgress> update) {
                OldWhenProgress.this.processQueue(progressHandlers, update);
                return update;
            }
        };
        final ValueHolder _resolve = new ValueHolder();
        _resolve.value = new Runnable<ProgressPromise<TResolve, TProgress>, PromiseImpl>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(PromiseImpl p) {
                _then.value = p.then;
                _resolve.value = new Runnable<ProgressPromise<TResolve, TProgress>, PromiseImpl>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(PromiseImpl promise) {
                        return promise;
                    }
                };
                _notify.value = new Runnable<Value<TProgress>, Value<TProgress>>(){

                    @Override
                    public Value<TProgress> run(Value<TProgress> progress) {
                        return progress;
                    }
                };
                OldWhenProgress.this.processQueue(handlers, p);
                progressHandlers.clear();
                handlers.clear();
                return p;
            }
        };
        Thenable promiseThen = new Thenable<TResolve, TProgress>(){

            @Override
            public ProgressPromise<TResolve, TProgress> then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
                return ((Thenable)_then.value).then(onFulfilled, onRejected, onProgress);
            }
        };
        Runnable promiseResolve = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                return (ProgressPromise)((Runnable)_resolve.value).run(OldWhenProgress.this.fulfilled(value));
            }
        };
        Runnable promiseResolvePromise = new Runnable<ProgressPromise<TResolve, TProgress>, ProgressPromise<TResolve, TProgress>>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(ProgressPromise<TResolve, TProgress> promise) {
                return (ProgressPromise)((Runnable)_resolve.value).run(OldWhenProgress.this.resolve(promise));
            }
        };
        Runnable promiseReject = new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                return (ProgressPromise)((Runnable)_resolve.value).run(OldWhenProgress.this.rejected(reason));
            }
        };
        Runnable promiseNotify = new Runnable<Value<TProgress>, Value<TProgress>>(){

            @Override
            public Value<TProgress> run(Value<TProgress> value) {
                return (Value)((Runnable)_notify.value).run(value);
            }
        };
        PromiseImpl promise = this.createPromise(promiseThen);
        ResolverImpl resolver = new ResolverImpl(promiseResolve, promiseResolvePromise, promiseReject, promiseNotify);
        return new DeferredImpl(promise, resolver);
    }

    protected PromiseImpl createPromise(Thenable<TResolve, TProgress> then) {
        return new PromiseImpl(then);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> some(List<? extends ProgressPromise<TResolve, TProgress>> promises, int howMany, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled) {
        return this.some(promises, howMany, onFulfilled, null, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> some(List<? extends ProgressPromise<TResolve, TProgress>> promises, int howMany, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, Value<List<? extends TResolve>>> onRejected) {
        return this.some(promises, howMany, onFulfilled, onRejected, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> some(final List<? extends ProgressPromise<TResolve, TProgress>> promises, final int howMany, final Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled, final Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, Value<List<? extends TResolve>>> onRejected, final Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
        OldWhenProgress<TResolve, TProgress> w1 = new OldWhenProgress<TResolve, TProgress>();
        final DeferredImpl d1 = super.deferInner();
        OldWhenProgress<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress> w2 = new OldWhenProgress<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress>();
        w2.when(promises, new Runnable<ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress>, List<? extends ProgressPromise<TResolve, TProgress>>>(){

            @Override
            public ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress> run(List<? extends ProgressPromise<TResolve, TProgress>> value) {
                int len = promises.size();
                final ValueHolder<Integer> toResolve = new ValueHolder<Integer>(Math.max(0, Math.min(howMany, len)));
                final ArrayList values = new ArrayList();
                final ValueHolder<Integer> toReject = new ValueHolder<Integer>(len - (Integer)toResolve.value + 1);
                final ArrayList reasons = new ArrayList();
                if ((Integer)toResolve.value == 0) {
                    d1.getResolver().resolve(values);
                } else {
                    Runnable notify = d1.resolver.notify;
                    final ValueHolder fulfillOne = new ValueHolder();
                    final ValueHolder rejectOne = new ValueHolder();
                    rejectOne.value = new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                        @Override
                        public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                            reasons.add(reason.getValue());
                            toReject.value = (Integer)toReject.value - 1;
                            if ((Integer)toReject.value == 0) {
                                rejectOne.value = null;
                                fulfillOne.value = null;
                                d1.getResolver().reject(new Value<List>(reasons, reason.getCause()));
                            }
                            return null;
                        }
                    };
                    fulfillOne.value = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                        @Override
                        public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                            values.add(value);
                            toResolve.value = (Integer)toResolve.value - 1;
                            if ((Integer)toResolve.value == 0) {
                                fulfillOne.value = null;
                                rejectOne.value = null;
                                d1.getResolver().resolve(values);
                            }
                            return null;
                        }
                    };
                    Runnable rejecter = new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                        @Override
                        public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                            return rejectOne.value != null ? (ProgressPromise)((Runnable)rejectOne.value).run(value) : null;
                        }
                    };
                    Runnable fulfiller = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                        @Override
                        public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                            return fulfillOne.value != null ? (ProgressPromise)((Runnable)fulfillOne.value).run(value) : null;
                        }
                    };
                    for (int i = 0; i < len; ++i) {
                        if (i >= promises.size()) continue;
                        OldWhenProgress.this.when((Thenable)promises.get(i), fulfiller, rejecter, notify);
                    }
                }
                d1.getPromise().then(onFulfilled, onRejected, onProgress);
                return null;
            }
        }).then(null, new Runnable<ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress>, Value<List<? extends ProgressPromise<TResolve, TProgress>>>>(){

            @Override
            public ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress> run(Value<List<? extends ProgressPromise<TResolve, TProgress>>> value) {
                d1.getResolver().reject(value.getCause());
                return null;
            }
        });
        return d1.getPromise();
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> someValues(List<TResolve> values, int howMany, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled) {
        return this.some(this.resolveValues(values), howMany, onFulfilled, null, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> any(List<? extends ProgressPromise<TResolve, TProgress>> promises, Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
        return this.any(promises, onFulfilled, null, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> any(List<? extends ProgressPromise<TResolve, TProgress>> promises, Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, Value<List<? extends TResolve>>> onRejected) {
        return this.any(promises, onFulfilled, onRejected, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> any(List<? extends ProgressPromise<TResolve, TProgress>> promises, final Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, Value<List<? extends TResolve>>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
        Runnable unwrapSingleResult = new Runnable<ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>>(){

            @Override
            public ProgressPromise<List<? extends TResolve>, TProgress> run(List<? extends TResolve> value) {
                if (onFulfilled != null) {
                    Object val = null;
                    if (value.size() > 0) {
                        val = value.get(0);
                    }
                    onFulfilled.run(val);
                }
                return null;
            }
        };
        return this.some(promises, 1, unwrapSingleResult, onRejected, onProgress);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> anyValues(List<TResolve> values, Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
        return this.any(this.resolveValues(values), onFulfilled, null, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> all(List<? extends ProgressPromise<TResolve, TProgress>> promises, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled) {
        return this.all(promises, onFulfilled, null, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> all(List<? extends ProgressPromise<TResolve, TProgress>> promises, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, Value<List<? extends TResolve>>> onRejected) {
        return this.all(promises, onFulfilled, onRejected, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> all(List<? extends ProgressPromise<TResolve, TProgress>> promises, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, Value<List<? extends TResolve>>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
        return this.map(promises, this.identity).then(onFulfilled, onRejected, onProgress);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> allValues(List<TResolve> values, Runnable<? extends ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>> onFulfilled) {
        return this.all(this.resolveValues(values), onFulfilled, null, null);
    }

    @SafeVarargs
    public final ProgressPromise<List<? extends TResolve>, TProgress> join(ProgressPromise<TResolve, TProgress> ... promises) {
        List<Object> input = promises == null ? new ArrayList() : Arrays.asList(promises);
        return this.map(input, this.identity);
    }

    @SafeVarargs
    public final ProgressPromise<List<? extends TResolve>, TProgress> join(TResolve ... values) {
        List<Object> input = values == null ? new ArrayList() : Arrays.asList(values);
        return this.mapValues(input, this.identity);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> map(List<? extends ProgressPromise<TResolve, TProgress>> promises, final Runnable<ProgressPromise<TResolve, TProgress>, TResolve> mapFunc) {
        OldWhenProgress<TResolve, TProgress> w1 = new OldWhenProgress<TResolve, TProgress>();
        final DeferredProgress<TResolve, TProgress> d1 = w1.defer();
        OldWhenProgress<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress> w2 = new OldWhenProgress<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress>();
        w2.when(promises, new Runnable<ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress>, List<? extends ProgressPromise<TResolve, TProgress>>>(){

            @Override
            public ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress> run(List<? extends ProgressPromise<TResolve, TProgress>> array) {
                final ValueHolder toResolve = new ValueHolder();
                int len = array.size();
                toResolve.value = len;
                final ArrayList<Object> results = new ArrayList<Object>(len);
                if ((Integer)toResolve.value == 0) {
                    d1.getResolver().resolve(results);
                } else {
                    for (int i = 0; i < len; ++i) {
                        results.add(null);
                    }
                    Runnable2 resolveOne = new Runnable2<Void, ProgressPromise<TResolve, TProgress>, Integer>(){

                        @Override
                        public Void run(ProgressPromise<TResolve, TProgress> item, final Integer index) {
                            OldWhenProgress.this.when(item, mapFunc).then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                                @Override
                                public ProgressPromise<TResolve, TProgress> run(TResolve mapped) {
                                    results.set(index, mapped);
                                    toResolve.value = (Integer)toResolve.value - 1;
                                    if ((Integer)toResolve.value == 0) {
                                        d1.getResolver().resolve(results);
                                    }
                                    return null;
                                }
                            }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                                @Override
                                public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                                    d1.getResolver().reject(new Value<List<Object>>(Arrays.asList(value.getValue()), value.getCause()));
                                    return null;
                                }
                            });
                            return null;
                        }
                    };
                    for (int i = 0; i < len; ++i) {
                        resolveOne.run(array.get(i), i);
                    }
                }
                return null;
            }
        }).then(null, new Runnable<ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress>, Value<List<? extends ProgressPromise<TResolve, TProgress>>>>(){

            @Override
            public ProgressPromise<List<? extends ProgressPromise<TResolve, TProgress>>, TProgress> run(Value<List<? extends ProgressPromise<TResolve, TProgress>>> value) {
                d1.getResolver().reject(value.getCause());
                return null;
            }
        });
        return d1.getPromise();
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> mapPromise(ProgressPromise<List<? extends TResolve>, TProgress> promise, final Runnable<ProgressPromise<TResolve, TProgress>, TResolve> mapFunc) {
        OldWhenProgress<List<? extends TResolve>, TProgress> when = new OldWhenProgress<List<? extends TResolve>, TProgress>();
        return when.when(promise, new Runnable<ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>>(){

            @Override
            public ProgressPromise<List<? extends TResolve>, TProgress> run(List<? extends TResolve> value) {
                return OldWhenProgress.this.mapValues(value, mapFunc);
            }
        });
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> mapValues(List<? extends TResolve> values, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> mapFunc) {
        return this.map(this.resolveValues(values), mapFunc);
    }

    public <T> ProgressPromise<T, TProgress> reduce(List<ProgressPromise<TResolve, TProgress>> promises, Reducer<T, TResolve> reduceFunc) {
        return this.reduceInner(promises, reduceFunc, null);
    }

    public <T> ProgressPromise<T, TProgress> reduce(List<ProgressPromise<TResolve, TProgress>> promises, Reducer<T, TResolve> reduceFunc, T initialValue) {
        OldWhenProgress<T, TProgress> when = new OldWhenProgress<T, TProgress>();
        return this.reduce(promises, reduceFunc, when.resolve(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reduce(List<ProgressPromise<TResolve, TProgress>> promises, Reducer<T, TResolve> reduceFunc, ProgressPromise<T, TProgress> initialValue) {
        return this.reduceInner(promises, reduceFunc, new Value<ProgressPromise<T, TProgress>>(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reduceValues(List<TResolve> values, Reducer<T, TResolve> reduceFunc) {
        return this.reduceInner(this.resolveValues(values), reduceFunc, null);
    }

    public <T> ProgressPromise<T, TProgress> reduceValues(List<TResolve> values, Reducer<T, TResolve> reduceFunc, T initialValue) {
        OldWhenProgress<T, TProgress> when = new OldWhenProgress<T, TProgress>();
        return this.reduceValues(values, reduceFunc, when.resolve(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reduceValues(List<TResolve> values, Reducer<T, TResolve> reduceFunc, ProgressPromise<T, TProgress> initialValue) {
        return this.reduceInner(this.resolveValues(values), reduceFunc, new Value<ProgressPromise<T, TProgress>>(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reducePromise(ProgressPromise<List<TResolve>, TProgress> promise, Reducer<T, TResolve> reduceFunc, T initialValue) {
        OldWhenProgress<T, TProgress> when = new OldWhenProgress<T, TProgress>();
        return this.reducePromise(promise, reduceFunc, when.resolve(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reducePromise(ProgressPromise<List<TResolve>, TProgress> promise, final Reducer<T, TResolve> reduceFunc, final ProgressPromise<T, TProgress> initialValue) {
        final DeferredProgress<TResolve, TProgress> d1 = new OldWhenProgress<TResolve, TProgress>().defer();
        OldWhenProgress<List<TResolve>, TProgress> w2 = new OldWhenProgress<List<TResolve>, TProgress>();
        w2.when(promise, new Runnable<ProgressPromise<List<TResolve>, TProgress>, List<TResolve>>(){

            @Override
            public ProgressPromise<List<TResolve>, TProgress> run(List<TResolve> values) {
                d1.getResolver().resolve(OldWhenProgress.this.reduceValues(values, reduceFunc, initialValue));
                return null;
            }
        }, new Runnable<ProgressPromise<List<TResolve>, TProgress>, Value<List<TResolve>>>(){

            @Override
            public ProgressPromise<List<TResolve>, TProgress> run(Value<List<TResolve>> value) {
                d1.getResolver().reject(value.getCause());
                return null;
            }
        });
        return d1.getPromise();
    }

    private <T> ProgressPromise<T, TProgress> reduceInner(List<ProgressPromise<TResolve, TProgress>> promises, final Reducer<T, TResolve> reduceFunc, final Value<ProgressPromise<T, TProgress>> initialValue) {
        OldWhenProgress<List<ProgressPromise<TResolve, TProgress>>, TProgress> w1 = new OldWhenProgress<List<ProgressPromise<TResolve, TProgress>>, TProgress>();
        final OldWhenProgress<TResolve, TProgress> w2 = new OldWhenProgress<TResolve, TProgress>();
        final DeferredProgress<TResolve, TProgress> d2 = w2.defer();
        w1.when(promises, new Runnable<ProgressPromise<List<ProgressPromise<TResolve, TProgress>>, TProgress>, List<ProgressPromise<TResolve, TProgress>>>(){

            @Override
            public ProgressPromise<List<ProgressPromise<TResolve, TProgress>>, TProgress> run(List<ProgressPromise<TResolve, TProgress>> array) {
                Reducer reducerWrapper = new Reducer<ProgressPromise<T, TProgress>, ProgressPromise<TResolve, TProgress>>(){

                    @Override
                    public ProgressPromise<T, TProgress> run(ProgressPromise<T, TProgress> current, final ProgressPromise<TResolve, TProgress> val, final int i, final int total) {
                        final DeferredProgress d3 = w2.defer();
                        return w2.when(current, new Runnable<ProgressPromise<T, TProgress>, T>(){

                            @Override
                            public ProgressPromise<T, TProgress> run(final T c) {
                                OldWhenProgress.this.when(val, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                                    @Override
                                    public ProgressPromise<TResolve, TProgress> run(TResolve v) {
                                        final Object value = reduceFunc.run(c, v, i, total);
                                        if (value instanceof ProgressPromise) {
                                            OldWhenProgress<Object, Object> w = new OldWhenProgress<Object, Object>();
                                            w.when((ProgressPromise)value, new Runnable<ProgressPromise<Object, Object>, Object>(){

                                                @Override
                                                public ProgressPromise<Object, Object> run(Object obj) {
                                                    d3.getResolver().resolve(value);
                                                    return null;
                                                }
                                            });
                                        } else {
                                            d3.getResolver().resolve(value);
                                        }
                                        return null;
                                    }
                                }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                                    @Override
                                    public ProgressPromise<TResolve, TProgress> run(Value<TResolve> v) {
                                        final Object value = reduceFunc.run(c, v.getValue(), i, total);
                                        if (value instanceof ProgressPromise) {
                                            OldWhenProgress<Object, Object> w = new OldWhenProgress<Object, Object>();
                                            w.when((ProgressPromise)value, new Runnable<ProgressPromise<Object, Object>, Object>(){

                                                @Override
                                                public ProgressPromise<Object, Object> run(Object obj) {
                                                    d3.getResolver().reject(value);
                                                    return null;
                                                }
                                            });
                                        } else {
                                            d3.getResolver().reject(value);
                                        }
                                        return null;
                                    }
                                });
                                return d3.getPromise();
                            }
                        });
                    }
                };
                ((ProgressPromise)OldWhenProgress.reduceList(array, reducerWrapper, initialValue)).then(new Runnable<ProgressPromise<T, TProgress>, T>(){

                    @Override
                    public ProgressPromise<T, TProgress> run(T value) {
                        d2.getResolver().resolve(value);
                        return null;
                    }
                }, new Runnable<ProgressPromise<T, TProgress>, Value<T>>(){

                    @Override
                    public ProgressPromise<T, TProgress> run(Value<T> value) {
                        d2.getResolver().reject(value);
                        return null;
                    }
                });
                return null;
            }
        }).then(null, new Runnable<ProgressPromise<List<ProgressPromise<TResolve, TProgress>>, TProgress>, Value<List<ProgressPromise<TResolve, TProgress>>>>(){

            @Override
            public ProgressPromise<List<ProgressPromise<TResolve, TProgress>>, TProgress> run(Value<List<ProgressPromise<TResolve, TProgress>>> value) {
                d2.getResolver().reject(value.getCause());
                return null;
            }
        });
        return d2.getPromise();
    }

    private static <T1, T2> T1 reduceList(List<T2> list, Reducer<T1, T2> reduceFunc, Value<T1> initialValue) {
        Object reduced;
        int len;
        int i = 0;
        int n = len = list == null ? 0 : list.size();
        if (initialValue == null) {
            if (i >= len) {
                throw new RuntimeException("No values to reduce.");
            }
            reduced = list.get(i++);
        } else {
            reduced = initialValue.getValue();
        }
        while (i < len) {
            reduced = reduceFunc.run(reduced, list.get(i), i, len);
            ++i;
        }
        return reduced;
    }

    public ProgressPromise<TResolve, TProgress> chain(ProgressPromise<TResolve, TProgress> promise, Resolver<TResolve, TProgress> resolver) {
        return this.chainInner(promise, resolver, null);
    }

    public ProgressPromise<TResolve, TProgress> chain(ProgressPromise<TResolve, TProgress> promise, Resolver<TResolve, TProgress> resolver, TResolve resolveValue) {
        return this.chainInner(promise, resolver, new Value<TResolve>(resolveValue));
    }

    private ProgressPromise<TResolve, TProgress> chainInner(ProgressPromise<TResolve, TProgress> promise, final Resolver<TResolve, TProgress> resolver, final Value<TResolve> resolveValue) {
        return this.when(promise, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve val) {
                val = resolveValue != null ? resolveValue.getValue() : val;
                resolver.resolve(val);
                return OldWhenProgress.this.resolve(val);
            }
        }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                resolver.reject(reason);
                return OldWhenProgress.this.rejected(reason);
            }
        }, new Runnable<Value<TProgress>, Value<TProgress>>(){

            @Override
            public Value<TProgress> run(Value<TProgress> value) {
                resolver.notify(value);
                return value;
            }
        });
    }

    public ProgressPromise<List<TResolve>, TProgress> sequence(List<Runnable<ProgressPromise<TResolve, TProgress>, Void>> tasks) {
        return this.sequence(tasks, null);
    }

    public <TArg> ProgressPromise<List<TResolve>, TProgress> sequence(List<Runnable<ProgressPromise<TResolve, TProgress>, TArg>> tasks, final TArg arg) {
        OldWhenProgress<Runnable<ProgressPromise<TResolve, TProgress>, TArg>, TProgress> w1 = new OldWhenProgress<Runnable<ProgressPromise<TResolve, TProgress>, TArg>, TProgress>();
        final OldWhenProgress w2 = new OldWhenProgress();
        final DeferredProgress<TResolve, TProgress> d1 = w2.defer();
        ProgressPromise list = w2.resolve(new ArrayList());
        w1.reduceValues(tasks, (Reducer)new Reducer<ProgressPromise<List<TResolve>, TProgress>, Runnable<ProgressPromise<TResolve, TProgress>, TArg>>(){

            @Override
            public ProgressPromise<List<TResolve>, TProgress> run(final ProgressPromise<List<TResolve>, TProgress> results, Runnable<ProgressPromise<TResolve, TProgress>, TArg> task, int currentIndex, int total) {
                PromiseImpl taskResult;
                final DeferredProgress d2 = w2.defer();
                try {
                    taskResult = task.run(arg);
                }
                catch (RuntimeException ex) {
                    taskResult = OldWhenProgress.this.rejected(new Value(ex));
                }
                OldWhenProgress.this.when(taskResult, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(final TResolve value) {
                        w2.when(results, new Runnable<ProgressPromise<List<TResolve>, TProgress>, List<TResolve>>(){

                            @Override
                            public ProgressPromise<List<TResolve>, TProgress> run(List<TResolve> results) {
                                results.add(value);
                                d2.getResolver().resolve(results);
                                return null;
                            }
                        });
                        return null;
                    }
                }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                        d1.getResolver().reject(new Value<List<Object>>(Arrays.asList(value.getValue()), value.getCause()));
                        return null;
                    }
                });
                return d2.getPromise();
            }
        }, (Object)list).then(new Runnable<ProgressPromise<ProgressPromise<List<TResolve>, TProgress>, TProgress>, ProgressPromise<List<TResolve>, TProgress>>(){

            @Override
            public ProgressPromise<ProgressPromise<List<TResolve>, TProgress>, TProgress> run(ProgressPromise<List<TResolve>, TProgress> value) {
                w2.when(value, new Runnable<ProgressPromise<List<TResolve>, TProgress>, List<TResolve>>(){

                    @Override
                    public ProgressPromise<List<TResolve>, TProgress> run(List<TResolve> value) {
                        d1.getResolver().resolve(value);
                        return null;
                    }
                });
                return null;
            }
        });
        return d1.getPromise();
    }

    private <T1, T2> void processQueue(List<Runnable<T1, T2>> queue, T2 value) {
        for (Runnable<T1, T2> handler : queue) {
            handler.run(value);
        }
    }

    private List<ProgressPromise<TResolve, TProgress>> resolveValues(List<? extends TResolve> values) {
        if (values == null) {
            return null;
        }
        ArrayList<ProgressPromise<TResolve, TProgress>> promises = new ArrayList<ProgressPromise<TResolve, TProgress>>();
        for (TResolve value : values) {
            promises.add(value != null ? this.resolve(value) : null);
        }
        return promises;
    }

    protected class ResolverImpl
    implements Resolver<TResolve, TProgress> {
        public final Runnable<ProgressPromise<TResolve, TProgress>, TResolve> resolve;
        public final Runnable<ProgressPromise<TResolve, TProgress>, ProgressPromise<TResolve, TProgress>> resolvePromise;
        public final Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> reject;
        public final Runnable<Value<TProgress>, Value<TProgress>> notify;

        public ResolverImpl(Runnable<ProgressPromise<TResolve, TProgress>, TResolve> resolve, Runnable<ProgressPromise<TResolve, TProgress>, ProgressPromise<TResolve, TProgress>> resolvePromise, Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> reject, Runnable<Value<TProgress>, Value<TProgress>> notify) {
            this.resolve = resolve;
            this.resolvePromise = resolvePromise;
            this.reject = reject;
            this.notify = notify;
        }

        @Override
        public ProgressPromise<TResolve, TProgress> resolve(TResolve value) {
            return this.resolve.run(value);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> resolve(ProgressPromise<TResolve, TProgress> value) {
            return this.resolvePromise.run(value);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> reject(TResolve reason) {
            return this.reject(new Value(reason));
        }

        @Override
        public ProgressPromise<TResolve, TProgress> reject(Throwable reason) {
            return this.reject(new Value(reason));
        }

        @Override
        public ProgressPromise<TResolve, TProgress> reject(Value<TResolve> reason) {
            return this.reject.run(reason);
        }

        @Override
        public Value<TProgress> notify(TProgress update) {
            return this.notify(new Value(update));
        }

        @Override
        public Value<TProgress> notify(Value<TProgress> update) {
            return this.notify.run(update);
        }
    }

    protected class DeferredImpl
    implements DeferredProgress<TResolve, TProgress> {
        public final ResolverImpl resolver;
        public final PromiseImpl promise;

        DeferredImpl(PromiseImpl promise, ResolverImpl resolver) {
            this.promise = promise;
            this.resolver = resolver;
        }

        @Override
        public Resolver<TResolve, TProgress> getResolver() {
            return this.resolver;
        }

        @Override
        public ProgressPromise<TResolve, TProgress> getPromise() {
            return this.promise;
        }
    }

    protected class PromiseImpl
    implements PromiseExt<TResolve, TProgress> {
        private final Thenable<TResolve, TProgress> then;

        PromiseImpl(Thenable<TResolve, TProgress> then) {
            this.then = then;
        }

        @Override
        public ProgressPromise<TResolve, TProgress> then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
            return this.then(onFulfilled, null, null);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected) {
            return this.then(onFulfilled, onRejected, null);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            return this.then.then(onFulfilled, onRejected, onProgress);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> always(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilledOrRejected) {
            return this.always(onFulfilledOrRejected, null);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> always(final Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilledOrRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            return this.then(onFulfilledOrRejected, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                    return (ProgressPromise)onFulfilledOrRejected.run(reason.getValue());
                }
            }, onProgress);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> otherwise(Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected) {
            return this.then(null, onRejected);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> yield(final TResolve value) {
            return this.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(TResolve ignore) {
                    return OldWhenProgress.this.resolve(value);
                }
            });
        }

        @Override
        public ProgressPromise<TResolve, TProgress> yield(final Thenable<TResolve, TProgress> promise) {
            return this.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(TResolve ignore) {
                    return OldWhenProgress.this.resolve(promise);
                }
            });
        }

        @Override
        public PromiseState<TResolve> inspect() {
            return null;
        }
    }
}

